/****************************************************************************
**
** Copyright (C) 2023 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
    // Add dynamic dependency for mingw TC for Android packages on Windows.
    if (installer.value("os") == "win") {
        var mingw_tc_component = "qt.tools.win64_mingw900"
        component.addDependency(mingw_tc_component);
    }

    // add automatic dependency to Android main node if it's selected
    dependencyStr = "qt.qt6.661.android"
    // For release builds set the dependency directly to the host binary
    var hostDependencyStr = "";
    var hostDependency = component.value("Dependencies");
    if (hostDependency) {
        if (installer.value("os") == "x11") {
            hostDependencyStr = "qt.qt6.661.gcc_64"
        }
        if (installer.value("os") == "mac") {
            hostDependencyStr = "qt.qt6.661.clang_64"
        }
        if (installer.value("os") == "win") {
            hostDependencyStr = "qt.qt6.661.win64_mingw"
        }
        component.addDependency(hostDependencyStr);
    }

    // Set automatic dependencies
    // - for release builds add dependency to the main Android node
    component.addAutoDependOn(dependencyStr);
}

Component.prototype.createOperations = function()
{
    component.createOperations();

    initializeGenericValues(component.value("Name"), "Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64", "66", "/6.6.1/android_x86_64", "6.6.1", "%QT_QNX_CMAKE_TOOLCHAIN_FILE%");

    setOriginalHostValues(component.value("Name"), "6.6.1");

    if (installer.value("os") == "x11") {
        initializeValuesForLinux(component.value("Name"), "6.6.1", "libexec", "x86_64");
    }
    else if (installer.value("os") == "mac") {
        initializeValuesForMacOs(component.value("Name"), "6.6.1", "libexec", "x86_64");
    }
    else if (installer.value("os") == "win") {
        initializeValuesForWindows(component.value("Name"), "6.6.1", "bin", "x86_64");
    }
    else {
        console.log("Error: Os not recognized:" + installer.value("os"));
        return "";
    }

    // Set component name to a value so we can give each variable an unique value
    var unique_id = component.value("Name") + "-";

    // patch qmake (.bat)
    component.addOperation("Replace", installer.value(unique_id + "qmakeScript-PatchPath"), installer.value(unique_id + "originalQmakePath-PatchPath"), installer.value(unique_id + "newQmakePath-PatchPath"));

    // patch qt-cmake(.bat)
    component.addOperation("Replace", installer.value(unique_id + "qtCMakeScript-PatchPath"), installer.value(unique_id + "originalSetCMakePath-PatchPath"), installer.value(unique_id + "newSetCMakePath-PatchPath"), "regex");

    // Patch build time CMAke paths from qt-cmake-private(.bat) script
    component.addOperation("Replace", installer.value(unique_id + "qtCMakePrivateScript-PatchPath"), installer.value(unique_id + "originalSetCMakePath-PatchPath"), installer.value(unique_id + "newSetCMakePath-PatchPath"), "regex");

    // If we are using executables from windows in unix environment we need to add
    // execute rights for those; windows doesn't set it automatically at creating phase.

    if (installer.value("fromWindowsToUnix-Boolean") == "true") {
        console.log("Setting execute rights for needed files.");

        component.addOperation("Execute", "{0}", "chmod", "+x", installer.value(unique_id + "qmakeScript-PatchPath"));
        component.addOperation("Execute", "{0}", "chmod", "+x", installer.value(unique_id + "qtCMakeScript-PatchPath"));
        component.addOperation("Execute", "{0}", "chmod", "+x", installer.value(unique_id + "qtPathsScript-PatchPath"));
        component.addOperation("Execute", "{0}", "chmod", "+x", installer.value(unique_id + "qtCMakePrivateScript-PatchPath"));
        component.addOperation("Execute", "{0}", "chmod", "+x", installer.value(unique_id + "qtCMakeStandaloneTestScript-PatchPath"));
        component.addOperation("Execute", "{0}", "chmod", "+x", installer.value(unique_id + "qtConfigureModuleScript-PatchPath"));

        // scripts with '6' are available only from Qt 6.4.0 ->
        if ("661" == "dev" || "66" >= 64) {
            component.addOperation("Execute", "{0}", "chmod", "+x", installer.value(unique_id + "qmake6Script-PatchPath"));
            component.addOperation("Execute", "{0}", "chmod", "+x", installer.value(unique_id + "qtPaths6Script-PatchPath"));
            }
    }

    // Patch Host Prefix, Host Data and Host Spec paths from target_qt.conf
    component.addOperation("Replace", installer.value(unique_id + "targetQtConf-PatchPath"), installer.value(unique_id + "originalHostPrefix-PatchString"), installer.value(unique_id + "newHostPrefix-PatchString"));

    component.addOperation("Replace", installer.value(unique_id + "targetQtConf-PatchPath"), installer.value(unique_id + "originalHostData-PatchString"), installer.value(unique_id + "newHostData-PatchPath"));

    component.addOperation("Replace", installer.value(unique_id + "targetQtConf-PatchPath"), installer.value(unique_id + "originalHostSpec-PatchString"), installer.value(unique_id + "newHostSpec-PatchString"));

    // Patch HostLibraryExecutables from target_qt.conf
    component.addOperation("LineReplace", installer.value(unique_id + "targetQtConf-PatchPath"), "HostLibraryExecutables=", "HostLibraryExecutables=" + installer.value(unique_id + "newHostLibExecutables-PatchString"));

    // Append target_qt.conf with relative paths to documentation and examples
    component.addOperation("AppendFile", installer.value(unique_id + "targetQtConf-PatchPath"), installer.value(unique_id + "targetQtConf_documentation-PatchString"));

    // Add a new line to targetQtConf which AppendFile operation doesn't add automatically
    if (installer.value("os") == "win") {
        // \r\n = CR + LF used as a new line character in Windows
        component.addOperation("AppendFile", installer.value(unique_id + "targetQtConf-PatchPath"), "\r\n");
    }
    else {
        // \n = LF (Line Feed) used as a new line character in Unix/macOS
        component.addOperation("AppendFile", installer.value(unique_id + "targetQtConf-PatchPath"), "\n");
    }
    component.addOperation("AppendFile", installer.value(unique_id + "targetQtConf-PatchPath"), installer.value(unique_id + "targetQtConf_examples-PatchString"));

    // Patch Qt install path from qt.toolchain.cmake
    component.addOperation("Replace", installer.value(unique_id + "qtToolchainCmake-PatchPath"), originalQtHostPath(), installer.value(unique_id + "newQtHostPath-PatchPath"));

    // Patch Qt install paths from QtBuildInternalsExtra.cmake
    component.addOperation("Replace", installer.value(unique_id + "qtBuildInternalsExtraCmake-PatchPath"), installer.value(unique_id + "originalBIPrefix-PatchPath"), installer.value("TargetDir"));

    component.addOperation("Replace", installer.value(unique_id + "qtBuildInternalsExtraCmake-PatchPath"), installer.value(unique_id + "originalHostTargetPath-PatchString"), installer.value(unique_id + "qtPath-PatchPath"));

    // Patch Qt install path from qtpaths(.bat)
    component.addOperation("Replace", installer.value(unique_id + "qtPathsScript-PatchPath"), installer.value(unique_id + "originalQtPathsPath-PatchPath"), installer.value(unique_id + "newQtPathsPath-PatchPath"));

    if ("661" == "dev" || "66" >= 64) {

        // Patch Qt install path from Qt6Dependencies.cmake if file exist; it isn't available before Qt 6.4.0
        component.addOperation("Replace", installer.value(unique_id + "qt6DependenciesCMakePath-PatchPath"), originalQtHostPath(), installer.value(unique_id + "newQtHostPath-PatchPath"));

        // patch qmake6(.bat) if file exist; it isn't available before Qt 6.4.0
        component.addOperation("Replace", installer.value(unique_id + "qmake6Script-PatchPath"), installer.value(unique_id + "originalQmakePath-PatchPath"), installer.value(unique_id + "newQmakePath-PatchPath"));

        // Patch Qt install path from qtpaths6(.bat) if file exist; it isn't available before Qt 6.4.0
        component.addOperation("Replace", installer.value(unique_id + "qtPaths6Script-PatchPath"), installer.value(unique_id + "originalQtPathsPath-PatchPath"), installer.value(unique_id + "newQtPathsPath-PatchPath"));
    }

    // Patch default ndk host from qdevice.pri
    component.addOperation("LineReplace", installer.value(unique_id + "qdeviceFile-PatchString"), "DEFAULT_ANDROID_NDK_HOST =", "DEFAULT_ANDROID_NDK_HOST = " + installer.value(unique_id + "newNDKHost-PatchString"));

    addInitQtPatchOperation(component, installer.value(unique_id + "platform-PatchString"), installer.value(unique_id + "qtPath-PatchPath"), installer.value(unique_id + "qmakeScript-PatchPath"), "emb-arm-qt5");

    if (installer.value("SDKToolBinary") == "")
        return;

    // add Qt into QtCreator
    component.addOperation("Execute",
                           ["@SDKToolBinary@", "addQt",
                            "--id", component.name,
                            "--name", "Qt %{Qt:Version} for Android x86_64",
                            "--type", "Qt4ProjectManager.QtVersion.Android",
                            "--qmake", installer.value(unique_id + "qmakeScript-PatchPath"),
                            "UNDOEXECUTE",
                            "@SDKToolBinary@", "rmQt", "--id", component.name]);

    // create qt.conf file
    createQtConfFiles(component, installer.value("TargetDir") + "/6.6.1/android_x86_64", "Qt-6.6.1");

    // patch qconfig.pri
    // is this OpenSource installation?
    var isOpenSource = "true";
    if (['true', 'yes', '1'].indexOf(isOpenSource) >= 0) {
        component.addOperation("LineReplace", installer.value(unique_id + "qconfigFile-PatchString"), "QT_EDITION =", "QT_EDITION = OpenSource");
    }
    component.addOperation("Replace", installer.value(unique_id + "qconfigFile-PatchString"), installer.value(unique_id + "originalLicheck-PatchString"), installer.value(unique_id + "newLicheck-PatchString"));
}

