set(__qt_toolchain_used_variables
    QT_CHAINLOAD_TOOLCHAIN_FILE
    QT_TOOLCHAIN_INCLUDE_FILE
    QT_TOOLCHAIN_RELOCATABLE_CMAKE_DIR
    QT_TOOLCHAIN_RELOCATABLE_PREFIX)


# Make cache variables used by this toolchain file available to the
# try_compile command that operates on sources files.
list(APPEND CMAKE_TRY_COMPILE_PLATFORM_VARIABLES ${__qt_toolchain_used_variables})
list(REMOVE_DUPLICATES CMAKE_TRY_COMPILE_PLATFORM_VARIABLES)

# Turn the environment variables that are created at the end of this
# file into proper variables. This is needed for try_compile calls
# that operate on whole projects.
if($ENV{_QT_TOOLCHAIN_VARS_INITIALIZED})
    foreach(var ${__qt_toolchain_used_variables})
        set(${var} "$ENV{_QT_TOOLCHAIN_${var}}")
    endforeach()
endif()


    set(__qt_initial_qt_host_path "/Users/qt/work/install")
    if(NOT DEFINED QT_HOST_PATH AND EXISTS "${__qt_initial_qt_host_path}")
        set(QT_HOST_PATH "${__qt_initial_qt_host_path}" CACHE PATH "" FORCE)
    endif()

    set(__qt_initial_qt_host_path_cmake_dir "/Users/qt/work/install/lib/cmake")
    if(NOT DEFINED QT_HOST_PATH_CMAKE_DIR AND EXISTS "${__qt_initial_qt_host_path_cmake_dir}")
        set(QT_HOST_PATH_CMAKE_DIR "${__qt_initial_qt_host_path_cmake_dir}" CACHE PATH "" FORCE)
    endif()



set(CMAKE_OSX_DEPLOYMENT_TARGET "13.0" CACHE STRING "")
set(QT_OSX_ARCHITECTURES "arm64;x86_64" CACHE STRING "List of architectures Qt was built with")

# Only build multiple architectures when building Qt itself. Can be explicitly enabled or disabled.
if((QT_REPO_MODULE_VERSION AND NOT QT_FORCE_SINGLE_QT_OSX_ARCHITECTURE) OR QT_FORCE_ALL_QT_OSX_ARCHITECTURES)
    set(__qt_toolchain_building_qt_repo TRUE)
    set(CMAKE_OSX_ARCHITECTURES "${QT_OSX_ARCHITECTURES}" CACHE STRING "")
endif()

if((NOT CMAKE_GENERATOR STREQUAL "Xcode" AND NOT __qt_toolchain_building_qt_repo)
    OR (CMAKE_GENERATOR STREQUAL "Xcode" AND __qt_uikit_sdk AND NOT QT_NO_SET_OSX_ARCHITECTURES))
    set(CMAKE_OSX_ARCHITECTURES "arm64" CACHE STRING "")
endif()

set(CMAKE_SYSTEM_NAME "iOS" CACHE STRING "")
if(CMAKE_GENERATOR STREQUAL "Xcode" AND NOT QT_NO_XCODE_EMIT_EPN)
    set_property(GLOBAL PROPERTY XCODE_EMIT_EFFECTIVE_PLATFORM_NAME OFF)
endif()

if(NOT "${QT_CHAINLOAD_TOOLCHAIN_FILE}" STREQUAL "")
    set(__qt_chainload_toolchain_file "${QT_CHAINLOAD_TOOLCHAIN_FILE}")
endif()
if(__qt_chainload_toolchain_file)
    get_filename_component(__qt_chainload_toolchain_file_real_path
                          "${__qt_chainload_toolchain_file}" REALPATH)
    if(__qt_chainload_toolchain_file_real_path STREQUAL CMAKE_CURRENT_LIST_FILE)
        message(FATAL_ERROR
                "Woah, the Qt toolchain file tried to include itself recusively! '${__qt_chainload_toolchain_file}' "
                "Make sure to remove qtbase/CMakeCache.txt and reconfigure qtbase with 'cmake' "
                "rather than 'qt-cmake', and then you can reconfigure your own project."
        )
    elseif(NOT EXISTS "${__qt_chainload_toolchain_file_real_path}")
        message(WARNING "The toolchain file to be chainloaded "
            "'${__qt_chainload_toolchain_file}' does not exist.")
    else()
        include("${__qt_chainload_toolchain_file}")
        set(__qt_chainload_toolchain_file_included TRUE)
    endif()
    unset(__qt_chainload_toolchain_file)
endif()



# Compute dynamically the Qt installation prefix from the location of this file. This allows
# the usage of the toolchain file when the Qt installation is relocated.
get_filename_component(QT_TOOLCHAIN_RELOCATABLE_INSTALL_PREFIX
                       ${CMAKE_CURRENT_LIST_DIR}/../../../
                       ABSOLUTE)

# Compute the path to the installed Qt lib/cmake folder.
# We assume that the Qt toolchain location is inside the CMake Qt6 package, and thus the directory
# one level higher is what we're looking for.
get_filename_component(QT_TOOLCHAIN_RELOCATABLE_CMAKE_DIR "${CMAKE_CURRENT_LIST_DIR}/.." ABSOLUTE)

# REROOT_PATH_ISSUE_MARKER
# There's a subdirectory check in cmake's cmFindCommon::RerootPaths() function, that doesn't handle
# the case of CMAKE_PREFIX_PATH == CMAKE_FIND_ROOT_PATH for a particular pair of entries.
# Instead of collapsing the search prefix (which is the case when one is a subdir of the other),
# it concatenates them creating an invalid path. Workaround it by setting the root path to the
# Qt install prefix, and the prefix path to the lib/cmake subdir.
list(PREPEND CMAKE_PREFIX_PATH "${QT_TOOLCHAIN_RELOCATABLE_CMAKE_DIR}")
list(PREPEND CMAKE_FIND_ROOT_PATH "${QT_TOOLCHAIN_RELOCATABLE_INSTALL_PREFIX}")

# Let CMake load our custom platform modules.
# CMake-provided platform modules take precedence.
if(NOT QT_AVOID_CUSTOM_PLATFORM_MODULES)
    list(PREPEND CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR}/platforms")
endif()

# Handle packages located in QT_ADDITIONAL_PACKAGES_PREFIX_PATH when cross-compiling. Needed for
# Conan.
# We prepend to CMAKE_PREFIX_PATH so that a find_package(Qt6Foo) call works, without having to go
# through the Qt6 umbrella package. The paths must end in lib/cmake to esnsure the package is found.
# See REROOT_PATH_ISSUE_MARKER.
# We prepend to CMAKE_FIND_ROOT_PATH, due to the bug mentioned at REROOT_PATH_ISSUE_MARKER.
set(__qt_toolchain_additional_packages_prefixes "")
if(QT_ADDITIONAL_PACKAGES_PREFIX_PATH)
    list(APPEND __qt_toolchain_additional_packages_prefixes
         ${QT_ADDITIONAL_PACKAGES_PREFIX_PATH})
endif()
if(DEFINED ENV{QT_ADDITIONAL_PACKAGES_PREFIX_PATH}
    AND NOT "$ENV{QT_ADDITIONAL_PACKAGES_PREFIX_PATH}" STREQUAL "")
    list(APPEND __qt_toolchain_additional_packages_prefixes
         $ENV{QT_ADDITIONAL_PACKAGES_PREFIX_PATH})
endif()

if(__qt_toolchain_additional_packages_prefixes)
    set(__qt_toolchain_additional_packages_root_paths "")
    set(__qt_toolchain_additional_packages_prefix_paths "")

    foreach(__qt_additional_path IN LISTS __qt_toolchain_additional_packages_prefixes)
        file(TO_CMAKE_PATH "${__qt_additional_path}" __qt_additional_path)
        get_filename_component(__qt_additional_path "${__qt_additional_path}" ABSOLUTE)
        set(__qt_additional_path_lib_cmake "${__qt_additional_path}")
        if(NOT __qt_additional_path_lib_cmake MATCHES "/lib/cmake$")
            string(APPEND __qt_additional_path_lib_cmake "/lib/cmake")
        endif()

        list(APPEND __qt_toolchain_additional_packages_root_paths
                    "${__qt_additional_path}")
        list(APPEND __qt_toolchain_additional_packages_prefix_paths
                    "${__qt_additional_path_lib_cmake}")
    endforeach()
    list(PREPEND CMAKE_PREFIX_PATH ${__qt_toolchain_additional_packages_prefix_paths})
    list(PREPEND CMAKE_FIND_ROOT_PATH ${__qt_toolchain_additional_packages_root_paths})

    unset(__qt_additional_path)
    unset(__qt_additional_path_lib_cmake)
    unset(__qt_toolchain_additional_packages_root_paths)
    unset(__qt_toolchain_additional_packages_prefix_paths)
endif()
unset(__qt_toolchain_additional_packages_prefixes)


    if("${QT_HOST_PATH}" STREQUAL "" OR NOT EXISTS "${QT_HOST_PATH}")
        message(FATAL_ERROR "To use a cross-compiled Qt, please specify a path to a host Qt installation by setting the QT_HOST_PATH cache variable.")
    endif()
    if("${QT_HOST_PATH_CMAKE_DIR}" STREQUAL "" OR NOT EXISTS "${QT_HOST_PATH_CMAKE_DIR}")
        message(FATAL_ERROR "To use a cross-compiled Qt, please specify a path to a host Qt installation CMake directory by setting the QT_HOST_PATH_CMAKE_DIR cache variable.")
    endif()

# Allow customization of the toolchain file by placing an additional file next to it.
set(__qt_toolchain_extra_file "${CMAKE_CURRENT_LIST_DIR}/qt.toolchain.extra.cmake")
if(EXISTS "${__qt_toolchain_extra_file}")
    include("${__qt_toolchain_extra_file}")
endif()

# Allow customization of the toolchain file by passing a path to an additional CMake file to be
# included.
if(QT_TOOLCHAIN_INCLUDE_FILE)
    get_filename_component(__qt_toolchain_include_file_real_path
                          "${QT_TOOLCHAIN_INCLUDE_FILE}" REALPATH)
    if(EXISTS "${__qt_toolchain_include_file_real_path}")
        include("${__qt_toolchain_include_file_real_path}")
    else()
        message(WARNING "The passed extra toolchain file to be included does not exist: "
                "${__qt_toolchain_include_file_real_path}")
    endif()
endif()

# Compile tests only see a restricted set of variables.
# All cache variables, this toolchain file uses, must be made available to compile tests,
# because this toolchain file will be included there too.
if(NOT ENV{_QT_TOOLCHAIN_VARS_INITIALIZED})
    set(ENV{_QT_TOOLCHAIN_VARS_INITIALIZED} ON)
    foreach(var ${__qt_toolchain_used_variables})
        set(ENV{_QT_TOOLCHAIN_${var}} "${${var}}")
    endforeach()
endif()
