/*
 * Copyright (C) 2009 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SQLiteFileSystem_h
#define SQLiteFileSystem_h

#include "wtf/Allocator.h"
#include "wtf/Threading.h"
#include "wtf/text/WTFString.h"

struct sqlite3;

namespace blink {

// A class that abstracts the file system related operations required
// by the WebKit database code.
class SQLiteFileSystem {
 public:
  // This class is used as a namespace, so instantiating it doesn't make sense.
  SQLiteFileSystem() = delete;

  // Initializes SQLite for Blink's use.
  //
  // This must be called exactly once in each renderer process that uses SQLite.
  static void initializeSQLite();

  // Opens a database file.
  //
  // initializeSQLite() must be called before this method is called.
  //
  // filemame - The name of the database file.
  // database - The SQLite structure that represents the database stored
  //            in the given file.
  static int openDatabase(const String& filename, sqlite3** database);

 private:
  // Registers Chromium's VFS with SQLite.
  static void registerSQLiteVFS();

#if DCHECK_IS_ON()
  static bool initialize_sqlite_called_;
#endif  // DCHECK_IS_ON()
};  // class SQLiteFileSystem

}  // namespace blink

#endif
