/*
 * Copyright (C) 2014 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SVGAnimatedAngle_h
#define SVGAnimatedAngle_h

#include "core/svg/SVGAngleTearOff.h"
#include "core/svg/SVGAnimatedEnumeration.h"
#include "platform/bindings/ScriptWrappable.h"
#include "platform/heap/Handle.h"

namespace blink {

class SVGAnimatedAngle final : public ScriptWrappable,
                               public SVGAnimatedProperty<SVGAngle> {
  DEFINE_WRAPPERTYPEINFO();
  USING_GARBAGE_COLLECTED_MIXIN(SVGAnimatedAngle);

 public:
  static SVGAnimatedAngle* Create(SVGElement* context_element) {
    return new SVGAnimatedAngle(context_element);
  }

  ~SVGAnimatedAngle() override;

  SVGAnimatedEnumeration<SVGMarkerOrientType>* OrientType() {
    return orient_type_.Get();
  }

  // SVGAnimatedPropertyBase:
  bool NeedsSynchronizeAttribute() override;
  void SynchronizeAttribute() override;

  void SetAnimatedValue(SVGPropertyBase*) override;
  void AnimationEnded() override;

  void Trace(blink::Visitor*) override;

  void TraceWrappers(const ScriptWrappableVisitor*) const override;

 protected:
  explicit SVGAnimatedAngle(SVGElement* context_element);

 private:
  Member<SVGAnimatedEnumeration<SVGMarkerOrientType>> orient_type_;
};

}  // namespace blink

#endif  // SVGAnimatedAngle_h
