# Useful URLs

Chromium has a lot of different pages for a lot of different things.
This page aims to be a repository of useful links that people may find useful.

## Build Status

* [Main buildbot waterfall](https://build.chromium.org/p/chromium/console)
* [Last Known Good Revision](http://chromium-status.appspot.com/lkgr) : Try bots pull this revision from trunk
* [List of the last 100 potential LKGRs](http://chromium-status.appspot.com/revisions)
* [Status dashboard for LKGR](https://build.chromium.org/p/chromium/lkgr-status/)
* https://build.chromium.org/p/tryserver.chromium/waterfall?committer=developer@chromium.org : Try bot runs, by developer
* [Tree uptime stats](https://chromium-status.appspot.com/status_viewer)
* [Commit queue status](https://chromium-cq-status.appspot.com)
* [Pending commit queue jobs](https://codereview.chromium.org/search?closed=3&commit=2&limit=50)

## For Sheriffs

* https://sheriff-o-matic.appspot.com/ : Sheriff-o-Matic
* https://build.chromium.org/p/chromium.chromiumos/waterfall?show_events=true&reload=120&failures_only=true : List of failing bots for a waterfall(chromium.chromiumos as an example)
* https://build.chromium.org/p/chromium.linux/waterfall?show_events=true&reload=120&builder=Linux%20Builder%20x64&builder=Linux%20Builder%20(dbg) : Monitor one or multiple bots(Linux Builder x64 and Linux Builder (dbg) on chromium.linux as an example)
* https://build.chromium.org/p/chromium.win/waterfall/help : Customize the waterfall view for a waterfall(using chromium.win as an example)
* [Lists historical test results for the bots](https://test-results.appspot.com/dashboards/flakiness_dashboard.html)

## Release Information

* [Current release versions of Chrome on all channels](https://omahaproxy.appspot.com/viewer)
* [Looks up the revision of a build/release version](https://omahaproxy.appspot.com/)

## Source Information

* [Code Search](https://cs.chromium.org/)
* https://cs.chromium.org/SEARCH_TERM : Code Search for a specific SEARCH\_TERM
* [Gitiles Source Code Browser](https://chromium.googlesource.com/chromium/src/)
* https://chromium.googlesource.com/chromium/src/+log/b6cfa6a..9a2e0a8?pretty=fuller : Git changes in revision range(also works for build numbers)
* https://build.chromium.org/f/chromium/perf/dashboard/ui/changelog.html?url=/trunk/src&mode=html&range=SUCCESS_REV:FAILURE_REV : SVN changes in revision range
* https://build.chromium.org/f/chromium/perf/dashboard/ui/changelog_blink.html?url=/trunk&mode=html&range=SUCCESS_REV:FAILURE_REV : Blink changes in revision range

## Communication

* [Chromium Developers List](https://groups.google.com/a/chromium.org/group/chromium-dev/topics)
* [Chromium Users List](https://groups.google.com/a/chromium.org/group/chromium-discuss/topics)
