# ProxySQL v1.2.2

Release date: 2016-09-02

## Performance improvement

* Connection Pool: reduced connection pool contention adding a per-thread connection cache. This improve performance for thousands of connections and a very high value of `mysql-threads` : [#644](../../../../issues/#644)
* Logger: minor performance improvement if the Logger is disabled : [#644](../../../../issues/644)

## Usability improvement

* Monitor: when a read_only check is timing out it is reported in error log : [#640](../../../../issues/640)
* Monitor: `monitor` tables now reports time in microsecond unixepoch : [#659](../../../../issues/659)
* Monitor: added `_us` to columns in `monitor` tables to specific time unit : [#650](../../../../issues/650)
* Compile: slightly improved compiling time
* Compile: do not compile examples for libdaemon : [#654](../../../../issues/654)
* Monitor: when a note is lagging, the event is logged as warning and not info
* Connection Pool: when a node is shunned, the event is logged as an error
* Admin: indented the output of `SHOW CREATE TABLE` 
* Doc: updated documentation of Query Processor
* Doc: updated documentation of Query Cache
* Connection: added connection attributes to connections generated by ProxySQL : [#672](../../../../issues/672)
* Admin: improved defaults in `proxysql.cnf`
* Admin: doubled the default value for `mysql-connect_retries_on_failure` : [#666](../../../../issues/666)
* General: added support for `chkconfig` for RHEL and Centos : [#675](../../../../issues/675)
* Admin: `scheduler`.`id` is now `AUTOINCREMENT`

## New features

* Admin: added new column `comment` in `mysql_servers` , `mysql_replication_hostgroups` , `mysql_query_rules` and `scheduler` : [#643](../../../../issues/643)
* Query Cache: added new variable mysql-query_cache_size_MB : [#171](../../../../issues/171)
* Query Cache: query cache metrics are now avaible in `stats_mysql_global` : [#140](../../../../issues/140)
* Admin: `mysql_replication_hostgroups` is now configurable via config file : [#648](../../../../issues/648)
* Query Processor: added new variable `mysql-query_processor_iterations` with a default value of 0 (backward compatible)
* Query Processor: if `mysql_query_rules`.`flagOUT` is set and `mysql-query_processor_iterations` is greater than 0, a matching rule will set `flagIN` and starts processing rules from the beginning up to `mysql-query_processor_iterations` iterations
* `proxysql_galera_checker.sh` now supports reader and writer hostgroups
* `proxysql_galera_checker.sh` now supports case when the only available node is in Desync
* Compile: `make` now allows to compile without `jemalloc` . This should be used only for system that do not support it! : [#654](../../../../issues/654)
* Admin: added column `active` in `scheduler` : [#649](../../../../issues/649)
* Admin: `scheduler` is now configurable via config file : [#658](../../../../issues/658)


## Bug fixes

* Monitor: Galera check scripts were not included in packages
* Monitor: if a server is configured as OFFLINE_SOFT in writer_hostgroup, do not try to bring it online : [#641](../../../../issues/641)
* Admin: if config db is not present, config file was not loaded : [#617](../../../../issues/617)
* Connection Pool: disable multiplexing if FLUSH TABLE WITH READ LOCK is executed : [#613](../../../../issues/613)
* Stats: statistics were not avaible for `REPLACE` commands
* Monitor: slaves lagging were not being shunned : [#652](../../../../issues/652)
* Compile: enable backtrace only with glibc : [#654](../../../../issues/654)
* Misc: few minor bug fixes
* Admin: scheduler did not load at start time : [#665](../../../../issues/665)
* Compile: failed to compile on Fedora 24 : [#671](../../../../issues/671)
* Monitor: if more than one replication hostgroups exist, monitor will constantly try to reconfigure : [#667](../../../../issues/667)

## Contributors

Thanks to contributors, in alphabetical order:
* @amnk
* @aydancoskun
* @dveeden
* @fmbiete
* @krzysztof-ksiazek
* @ryanschwartz
* @Tusamarco
* @VoroOnestic
