##! Events generated by the LDAP analyzer.
##!
##! See See `RFC4511 <https://datatracker.ietf.org/doc/html/rfc4511>`__.

## Event generated for each LDAPMessage (either direction).
##
## c: The connection.
##
## message_id: The messageID element.
##
## opcode: The protocolOp field in the message.
##
## result: The result code if the message contains a result.
##
## matched_dn: The DN if the message contains a result.
##
## diagnostic_message: Diagnostic message if the LDAP message contains a result.
##
## object: The object name this message refers to.
##
## argument: Additional arguments this message includes.
global LDAP::message: event(
  c: connection,
  message_id: int,
  opcode: LDAP::ProtocolOpcode,
  result: LDAP::ResultCode,
  matched_dn: string,
  diagnostic_message: string,
  object: string,
  argument: string
);

## Event generated for each LDAPMessage containing a BindRequest.
##
## c: The connection.
##
## message_id: The messageID element.
##
## version: The version field in the BindRequest.
##
## name: The name field in the BindRequest.
##
## auth_type: The auth type field in the BindRequest.
##
## auth_info: Additional information related to the used auth type.
global LDAP::bind_request: event(
  c: connection,
  message_id: int,
  version: int,
  name: string,
  auth_type: LDAP::BindAuthType,
  auth_info: string
);

## Event generated for each LDAPMessage containing a SearchRequest.
##
## c: The connection.
##
## message_id: The messageID element.
##
## base_object: The baseObject field in the SearchRequest.
##
## scope: The scope field in the SearchRequest.
##
## deref_alias: The derefAlias field in the SearchRequest
##
## size_limit: The sizeLimit field in the SearchRequest.
##
## time_limit: The timeLimit field in the SearchRequest.
##
## types_only: The typesOnly field in the SearchRequest.
##
## filter: The string representation of the filter field in the SearchRequest.
##
## attributes: Additional attributes of the SearchRequest.
global LDAP::search_request: event (
  c: connection,
  message_id: int,
  base_object: string,
  scope: LDAP::SearchScope,
  deref: LDAP::SearchDerefAlias,
  size_limit: int,
  time_limit: int,
  types_only: bool,
  filter: string,
  attributes: vector of string
);

## Event generated for each SearchResultEntry in LDAP messages.
##
## c: The connection.
##
## message_id: The messageID element.
##
## object_name: The object name in the SearchResultEntry.
global LDAP::search_result_entry: event (
  c: connection,
  message_id: int,
  object_name: string
);

## Event generated for each ExtendedRequest in LDAP messages.
##
## c: The connection.
##
## message_id: The messageID element.
##
## request_name: The name of the extended request.
##
## request_value: The value of the extended request (empty if missing).
global LDAP::extended_request: event (
  c: connection,
  message_id: int,
  request_name: string,
  request_value: string
);

## Event generated for each ExtendedResponse in LDAP messages.
##
## c: The connection.
##
## message_id: The messageID element.
##
## result: The result code of the response.
##
## response_name: The name of the extended response (empty if missing).
##
## response_value: The value of the extended response (empty if missing).
global LDAP::extended_response: event (
  c: connection,
  message_id: int,
  result: LDAP::ResultCode,
  response_name: string,
  response_value: string
);

## Event generated when a plaintext LDAP connection switched to TLS.
##
## c: The connection.
##
global LDAP::starttls: event(c: connection);
