/*****************************************************************************
 *
 *  Copyright 2012 Richard Hacker (lerichi at gmx dot net)
 *
 *  This file is part of the rtipc library.
 *
 *  The rtipc library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published
 *  by the Free Software Foundation, either version 3 of the License, or (at
 *  your option) any later version.
 *
 *  The rtipc library is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 *  License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with the rtipc library. If not, see <http://www.gnu.org/licenses/>.
 *
 *****************************************************************************/

#include "Debug.h"

#include "RxPdo.h"
#include "Group.h"

using namespace RtIPC;

//////////////////////////////////////////////////////////////////////////////
RxPdo::RxPdo (const Group* group, const std::string& name,
        const BB::DataType& datatype, size_t n,
        void *addr, unsigned char *connected):
    Signal(group->bbGroup, name, datatype, n),
    group(group), addr(addr), connected(connected)
{
    *connected = 0;
}
