from typing import List

from pytest_container import DerivedContainer


SLE_CONTAINERFILE = """WORKDIR /opt/playground

RUN zypper --non-interactive in python3 python3-pip && \
    pip install urllib3 aiohttp lxml && \
    if python3 -c "import sys; from platform import python_version_tuple; sys.exit(0 if int(python_version_tuple()[1]) < 8 else 1)"; then pip install typing; fi

COPY node_modules.py /bin/node_modules.py
COPY data/package-lock.json /opt/playground/package-lock.json"""

OPENSUSE_CONTAINERFILE = """WORKDIR /opt/playground

RUN zypper -n in python3 python3-urllib3 python3-aiohttp python3-lxml && \
    if python3 -c "import sys; from platform import python_version_tuple; sys.exit(0 if int(python_version_tuple()[1]) < 8 else 1)"; then zypper -n in python3-typing_extensions; fi
COPY node_modules.py /bin/node_modules.py
COPY data/package-lock.json /opt/playground/package-lock.json"""


TUMBLEWEED_CONTAINER = DerivedContainer(
    base="registry.opensuse.org/opensuse/tumbleweed:latest",
    containerfile=OPENSUSE_CONTAINERFILE,
)
LEAP_CONTAINERS = [
    DerivedContainer(
        base="registry.opensuse.org/opensuse/leap:15.3",
        containerfile=OPENSUSE_CONTAINERFILE,
    ),
    DerivedContainer(
        base="registry.opensuse.org/opensuse/leap:15.2",
        containerfile=OPENSUSE_CONTAINERFILE,
    ),
]
SLE_BCI_CONTAINERS = [
    DerivedContainer(
        base="registry.suse.com/suse/sle15:15.3",
        containerfile=SLE_CONTAINERFILE,
    ),
]

CONTAINER_IMAGES: List[DerivedContainer] = (
    [TUMBLEWEED_CONTAINER] + LEAP_CONTAINERS + SLE_BCI_CONTAINERS
)


def test_fetch_debug_js_deps(auto_container):
    """
    This test tries to fetch the dependencies of a stripped down
    package-log.json from debug (https://github.com/visionmedia/debug)
    """
    auto_container.connection.run_expect(
        [0], "cd /opt/playground && /bin/node_modules.py --download"
    )

    tarballs = set(
        auto_container.connection.file("/opt/playground/").listdir()
    )
    tarballs.remove("package-lock.json")
    expected_tarballs = set(
        [
            "acorn-7.4.1.tgz",
            "acorn-node-1.8.2.tgz",
            "acorn-walk-7.2.0.tgz",
            "array-from-2.1.1.tgz",
            "balanced-match-1.0.2.tgz",
            "brace-expansion-1.1.11.tgz",
            "brfs-2.0.2.tgz",
            "browser-stdout-1.3.1.tgz",
            "buffer-equal-0.0.1.tgz",
            "buffer-from-1.1.2.tgz",
            "commander-2.15.1.tgz",
            "concat-map-0.0.1.tgz",
            "concat-stream-1.6.2.tgz",
            "convert-source-map-1.8.0.tgz",
            "core-util-is-1.0.2.tgz",
            "d-1.0.1.tgz",
            "dash-ast-1.0.0.tgz",
            "debug-3.1.0.tgz",
            "deep-is-0.1.3.tgz",
            "diff-3.5.0.tgz",
            "duplexer2-0.1.4.tgz",
            "es5-ext-0.10.53.tgz",
            "es6-iterator-2.0.3.tgz",
            "es6-map-0.1.5.tgz",
            "es6-set-0.1.5.tgz",
            "es6-symbol-3.1.1.tgz",
            "es6-symbol-3.1.3.tgz",
            "escape-string-regexp-1.0.5.tgz",
            "escodegen-1.14.3.tgz",
            "esprima-4.0.1.tgz",
            "estraverse-4.3.0.tgz",
            "estree-is-function-1.0.0.tgz",
            "esutils-2.0.3.tgz",
            "event-emitter-0.3.5.tgz",
            "ext-1.4.0.tgz",
            "fast-levenshtein-2.0.6.tgz",
            "fs.realpath-1.0.0.tgz",
            "function-bind-1.1.1.tgz",
            "get-assigned-identifiers-1.2.0.tgz",
            "glob-7.1.2.tgz",
            "growl-1.10.5.tgz",
            "has-1.0.3.tgz",
            "has-flag-3.0.0.tgz",
            "he-1.1.1.tgz",
            "inflight-1.0.6.tgz",
            "inherits-2.0.4.tgz",
            "isarray-1.0.0.tgz",
            "is-core-module-2.6.0.tgz",
            "levn-0.3.0.tgz",
            "magic-string-0.25.1.tgz",
            "merge-source-map-1.0.4.tgz",
            "minimatch-3.0.4.tgz",
            "minimist-0.0.8.tgz",
            "minimist-1.2.5.tgz",
            "mkdirp-0.5.1.tgz",
            "mocha-5.2.0.tgz",
            "ms-2.0.0.tgz",
            "ms-2.1.2.tgz",
            "next-tick-1.0.0.tgz",
            "object-inspect-1.11.0.tgz",
            "once-1.4.0.tgz",
            "optionator-0.8.3.tgz",
            "path-is-absolute-1.0.1.tgz",
            "path-parse-1.0.7.tgz",
            "prelude-ls-1.1.2.tgz",
            "process-nextick-args-2.0.1.tgz",
            "quote-stream-1.0.2.tgz",
            "readable-stream-2.3.7.tgz",
            "resolve-1.20.0.tgz",
            "safe-buffer-5.1.2.tgz",
            "scope-analyzer-2.1.1.tgz",
            "shallow-copy-0.0.1.tgz",
            "source-map-0.5.7.tgz",
            "source-map-0.6.1.tgz",
            "sourcemap-codec-1.4.8.tgz",
            "static-eval-2.1.0.tgz",
            "static-module-3.0.4.tgz",
            "string_decoder-1.1.1.tgz",
            "supports-color-5.4.0.tgz",
            "through2-2.0.5.tgz",
            "type-1.2.0.tgz",
            "type-2.5.0.tgz",
            "type-check-0.3.2.tgz",
            "typedarray-0.0.6.tgz",
            "util-deprecate-1.0.2.tgz",
            "word-wrap-1.2.3.tgz",
            "wrappy-1.0.2.tgz",
            "xtend-4.0.2.tgz",
        ]
    )
    assert tarballs == expected_tarballs
