# Contributing to Meshtastic Firmware

We're excited that you're interested in contributing to the Meshtastic firmware! This document provides a high-level overview of how you can get involved.

## Important First Steps

Before you begin, please:

1. **Read our documentation**: Our [official documentation](https://meshtastic.org/docs/) is a crucial resource. It contains essential information about the project.

2. **Check out the firmware build guide**: For specific instructions on setting up your development environment and building the firmware, refer to our [Firmware Build Guide](https://meshtastic.org/docs/development/firmware/build/).

3. Read our [Code of Conduct](https://meshtastic.org/docs/legal/conduct/)

4. Join our [Discord community](https://discord.com/invite/ktMAKGBnBs) to connect with developers and other contributors to get help.

## Getting Help and Discussing Ideas

We encourage open communication and discussion before diving into code changes:

1. **Use GitHub Discussions**: For new ideas, questions, or to discuss potential changes, start a conversation in our [GitHub Discussions](https://github.com/meshtastic/firmware/discussions) first. This helps us collaborate and avoid duplicate work.

2. **Join our Discord**: For real-time chat and quick questions, join our [Discord server](https://discord.com/invite/ktMAKGBnBs). It's a great place to get help and connect with other developers and the community.

3. **Reporting Issues**: If you've identified a bug, please use our bug report template when creating a new issue in the [issue tracker](https://github.com/meshtastic/firmware/issues). Ensure you've searched existing issues to avoid duplicates.

## Making Contributions

> [!IMPORTANT]
> Before making any contributions, you must sign our Contributor License Agreement (CLA). You can do this by visiting https://cla-assistant.io/meshtastic/firmware. Be sure to use the GitHub account you will use to submit your contributions when signing.

1. Fork the repository
2. Create a new branch for your feature or bug fix
3. Make your changes
4. Test your changes thoroughly
5. Create a pull request with a clear description, using the provided template, of your changes. Be sure to enable "Allow edits from maintainers".

## Coding Standards

To ensure consistent code formatting across the project:

1. Install the [Trunk](https://marketplace.visualstudio.com/items?itemName=Trunk.io) extension for Visual Studio Code.
2. Before submitting your changes, run `trunk fmt` to automatically format your code according to our standards.

Adhering to these formatting guidelines helps maintain code consistency and makes the review process smoother.

Thank you for contributing to Meshtastic!
