| Host / plugin format                                         | 1 stereo input         | 1 stereo MAIN output     | 4 stereo MIX outputs     | 2 mono inputs            | 2 mono MAIN outputs      | 8 mono MIX outputs       |
| ------------------------------------------------------------ | ---------------------- | ------------------------ | ------------------------ | ------------------------ | ------------------------ | ------------------------ |
| [Ableton Live](https://www.ableton.com/) AUv2 inst           | :heavy_check_mark:     | :heavy_check_mark:       | :heavy_check_mark:       | :heavy_multiplication_x: | :heavy_multiplication_x: | :heavy_check_mark:`AAA` |
| [Ableton Live](https://www.ableton.com/) AUv2 fx             | :heavy_check_mark:`A`​ | :heavy_check_mark:       | :heavy_check_mark:`AA` | :heavy_multiplication_x: | :heavy_multiplication_x: | :heavy_check_mark:`AAA` |
| [Ableton Live](https://www.ableton.com/) AUv3 inst           | :heavy_check_mark:     | :heavy_check_mark:       | :heavy_check_mark:       | :heavy_multiplication_x: | :heavy_multiplication_x: | :heavy_check_mark:`AAA` |
| [Ableton Live](https://www.ableton.com/) AUv3 fx             | :heavy_check_mark:`A`​ | :heavy_check_mark:       | :heavy_check_mark:`AA` | :heavy_multiplication_x: | :heavy_multiplication_x: | :heavy_check_mark:`AAA` |
| [Ableton Live](https://www.ableton.com/) VST3                | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark:       | :heavy_check_mark:       | :heavy_check_mark:`AAA`  |
| [Ardour](https://ardour.org/) LV2                            |                        |                          |                          |                          |                          |                          |
| [AUM](https://kymatica.com/apps/aum) AUv3 instrument         |                        |                          |                          |                          |                          |                          |
| [AUM](https://kymatica.com/apps/aum) AUv3 fx | | | | | | |
| [Bitwig](https://www.bitwig.com/) VST3                       | :heavy_check_mark:     | :heavy_check_mark:       | :heavy_check_mark:       | :heavy_check_mark:       | :heavy_check_mark:       | :heavy_check_mark:       |
| [Carla](https://kx.studio/Applications:Carla) LV2            | :heavy_check_mark:`C` | :heavy_check_mark:`C` | :heavy_check_mark:`C` | :heavy_check_mark:`C` | :heavy_check_mark:`C` | :heavy_check_mark:`C` |
| [Carla](https://kx.studio/Applications:Carla) VST3           | :heavy_check_mark:`CC` | :heavy_check_mark:`CC` | :heavy_check_mark:`CC` | :heavy_check_mark:`CC` |:heavy_check_mark:`CC`|:heavy_check_mark:`CC`|
| [Cubase](https://www.steinberg.net/cubase/) VST3             | :heavy_check_mark:     | :heavy_check_mark:       | :heavy_check_mark:       | :heavy_check_mark:       | :heavy_check_mark:       | :heavy_check_mark:       |
| [JUCE AudioPluginHost](https://github.com/juce-framework/JUCE/blob/master/extras/AudioPluginHost/AudioPluginHost.jucer) LV2 |                        |                          |                          |                          |                          |                          |
| [JUCE AudioPluginHost](https://github.com/juce-framework/JUCE/blob/master/extras/AudioPluginHost/AudioPluginHost.jucer) VST3 |                        |                          |                          |                          |                          |                          |
| [JUCE AudioPluginHost](https://github.com/juce-framework/JUCE/blob/master/extras/AudioPluginHost/AudioPluginHost.jucer) AUv2 inst |                        |                          |                          |                          |                          |                          |
| [JUCE AudioPluginHost](https://github.com/juce-framework/JUCE/blob/master/extras/AudioPluginHost/AudioPluginHost.jucer) AUv2 fx |                        |                          |                          |                          |                          |                          |
| [JUCE AudioPluginHost](https://github.com/juce-framework/JUCE/blob/master/extras/AudioPluginHost/AudioPluginHost.jucer) AUv3 inst |                        |                          |                          |                          |                          |                          |
| [JUCE AudioPluginHost](https://github.com/juce-framework/JUCE/blob/master/extras/AudioPluginHost/AudioPluginHost.jucer) AUv3 fx |                        |                          |                          |                          |                          |                          |
| **Host / plugin format**                                     | **1 stereo input**     | **1 stereo MAIN output** | **4 stereo MIX outputs** | **2 mono inputs**        | **2 mono MAIN outputs**  | **8 mono MIX outputs**   |
| [LMMS](https://lmms.io/) LV2                                 |                        |                          |                          |                          |                          |                          |
| [LMMS](https://lmms.io/) VST3                                |                        |                          |                          |                          |                          |                          |
| [Logic Pro](https://www.apple.com/logic-pro) AUv2 inst       | :heavy_check_mark: `L` | :heavy_check_mark:       | :heavy_check_mark:       | :heavy_multiplication_x: | :heavy_multiplication_x:  | :heavy_check_mark:       |
| [Logic Pro](https://www.apple.com/logic-pro) AUv2 fx **`LL`** | :heavy_check_mark:    | :heavy_multiplication_x: | :heavy_multiplication_x: | :heavy_multiplication_x: | :heavy_multiplication_x: | :heavy_multiplication_x: |
| [Logic Pro](https://www.apple.com/logic-pro) AUv3 inst       | :heavy_check_mark: `L` | :heavy_check_mark:       | :heavy_check_mark:       | :heavy_multiplication_x: | :heavy_multiplication_x: | :heavy_check_mark: |
| [Logic Pro](https://www.apple.com/logic-pro) AUv3 fx **`LL`** | :heavy_check_mark:   | :heavy_multiplication_x: | :heavy_multiplication_x: | :heavy_multiplication_x: | :heavy_multiplication_x: | :heavy_multiplication_x: |
| [Mixxx](https://mixxx.org/) LV2                              |                        |                          |                          |                          |                          |                          |
| [Qtractor](https://www.qtractor.org/) LV2                    |                        |                          |                          |                          |                          |                          |
| [Qtractor](https://www.qtractor.org/) VST3                   |                        |                          |                          |                          |                          |                          |
| [Reaper](https://www.reaper.fm/) LV2                         |                        |                          |                          |                          |                          |                          |
| [Reaper](https://www.reaper.fm/) AUv2 inst                   | :heavy_check_mark:     | :heavy_check_mark:       | :heavy_check_mark:       | :heavy_multiplication_x: | :heavy_multiplication_x: | :heavy_multiplication_x: |
| [Reaper](https://www.reaper.fm/) AUv2 fx                     | `RR` | `RR` | `RR`   | `RR` | `RR`   | `RR`   |
| [Reaper](https://www.reaper.fm/) AUv3 inst                   | :heavy_check_mark:`R` | :heavy_check_mark:`R` | :heavy_check_mark:`R` | :heavy_multiplication_x: | :heavy_multiplication_x: | :heavy_multiplication_x: |
| [Reaper](https://www.reaper.fm/) AUv3 fx                     | `RR` | `RR` | `RR` | `RR` | `RR` | `RR` |
| [Reaper](https://www.reaper.fm/) VST3                        | :heavy_check_mark:     | :heavy_check_mark:       | :heavy_check_mark:       | :heavy_check_mark:       | :heavy_check_mark:       | :heavy_check_mark:       |

## Logic

`L` Via "Side Chain:" in the top-right of Logic's plugin window.

`LL` Only visible on stereo channels. For instance, on an empty or mono instrument track, the VMPC2000XL AU effect will not show up in the list of plugins.

## Ableton Live

`A` Can only be used as the main input for the effect. Nothing can be routed into it via Ableton Live's "Audio To" dropdowns.

`AA` Via "Audio From", and then select the name of the instrument track. VMPC2000XL's additional outputs will appear in the dropdown right below it.

`AAA` The same applies as for `AA`, with the addition that Ableton Live does support true mono busses. The resulting list of outputs is as follows:

| VMPC2000XL stereo bus | Ableton Live stereo bus   |
| --------------------- | ------------------------- |
| RECORD IN L/R         | 1/2-VMPC2000XL            |
| STEREO OUT L/R        | Pre FX/Post FX/Post Mixer |
| MIX 1/2               | 3/4-VMPC2000XL            |
| MIX 3/4               | 5/6-VMPC2000XL            |
| MIX 5/6               | 7/8-VMPC2000XL            |
| MIX 7/8               | 9/10-VMPC2000XL           |

| VMPC2000XL mono bus | Ableton Live stereo bus |
| ------------------- | ----------------------- |
| MIX 1               | 11/12-VMPC2000XL        |
| MIX 2               | 13/14-VMPC2000XL        |
| MIX 3               | 15/16-VMPC2000XL        |
| MIX 4               | 17/18-VMPC2000XL        |
| MIX 5               | 19/20-VMPC2000XL        |
| MIX 6               | 21/22-VMPC2000XL        |
| MIX 7               | 23/24-VMPC2000XL        |
| MIX 8               | 25/26-VMPC2000XL        |



## Carla

`C` In Carla, all LV2 and VST3 channels are exposed as mono channels, and you can use them any way you like. See the below table for mapping VMPC2000XL busses to Carla LV2/VST3 channels. The LV2 ports are named "Audio In" or "Audio Out" followed by a number.

`CC` The same applies as for `C`, except that the VST3 ports are named "input\_" or "output\_" followed by a number.

Note that VMPC2000XL tries to expose stereo and mono busses that duplicate each other. This is by design, to give the user more flexibility. For example, you can use MIX 1/2 with a stereo sound assigned to it on a stereo bus, and if MIX 1 has a mono sound assigned to it, and MIX 2 as well, then you can use these mono buses individually in the host (if the host supports it). Carla has taken a different approach than most other hosts, by saying "We expose every single channel of a plugin as a port, and the user can do whatever they like with it". This means that any stereo busses yield 2 ports, and any mono bus yields 1 port. In other words, in Carla there is no need to expose MIX1/2 as 2 mono busses. It would suffice to just expose 1 stereo bus, because it's very natural in Carla to use this bus in a split fashion.

These are VMPC2000XL's stereo busses mapped to Carla ports:

| VMPC2000XL stereo bus | Carla LV2 ports | Carla VST3 ports |
| -------------------------- | ---------------------------- | -------------------------- |
| RECORD IN L/R              | Audio In 1, Audio In 2 | input_1, input_2 |
| STEREO OUT L/R             | Audio Out 1, Audio Out 2 | output_1, output_2 |
| MIX 1/2                    | Audio Out 3, Audio Out 4 | output_3, output_4 |
| MIX 3/4                    | Audio Out 5, Audio Out 6 | output_5, output_6 |
| MIX 5/6                    | Audio Out 7, Audio Out 8 | output_7, output_8 |
| MIX 7/8                    | Audio Out 9, Audio Out 10 |  output_9, output_10 |

And these are VMPC2000XL's mono busses mapped to Carla ports (all of which are probably redundant in most cases, because in Carla you can achieve any kind of routing with the first 2 input ports, and the first 10 output ports):

| VMPC2000XL mono bus | Carla LV2 port | Carla VST3 port |
| ------------------------ | ---------------------------- | ------------------------ |
| STEREO IN L | Audio In 3 | input_3 |
| STEREO IN R | Audio In 4 | input_4 |
| MIX 1       | Audio Out 11| output_11  |
| MIX 2       | Audio Out 12| output_12  |
| MIX 3       | Audio Out 13| output_13  |
| MIX 4       | Audio Out 14| output_14  |
| MIX 5       | Audio Out 15| output_15  |
| MIX 6       | Audio Out 16| output_16  |
| MIX 7       | Audio Out 17| output_17  |
| MIX 8       | Audio Out 18| output_18  |

## AUv3

* Does not support plugin-initiated resizing. Use the host's facilities to resize VMPC2000XL, for example the `View:` dropdown in Logic, and Logic's own plugin window border can be used to change the size.
* Ableton Live currently does not allow resizing of an AUv3 in any way that I'm aware of. So, I hope the initial size works for you, else you're probably out of luck. I recommend using the AUv2 or VST3 instead.

## Reaper

`R` Reaper doesn't propagate the names of the busses in the AUv3i case, but they are present and they work.

`RR` Reaper does not show the AUv2 or AUv3 effect. That said, the AUv2 and AUv3 instrument can be inserted in effect slots in Reaper.

## Reaper LV2

When using the LV2 in Reaper, and when pressing the "Escape" key in VMPC2000XL to go to the MAIN screen, the plugin window is closed. This has been observed on Windows and macOS. The VST3i does not have this problem on either platform. On macOS this can be resolved by enabled "Send all keyboard input to plug-in". This setting is in the "FX" menu in the top-left of the plugin. This menu is not always visible, because in Reaper a plugin window can be "floating", "docked" and perhaps more. Try double-clicking the title bar to make this menu appear if you don't see it.

On Windows, the issue of the plugin window closing when you press the "Escape" key can be resolved by enabling "FX | Window float selected FX" or "FX | Dock FX window in Docker".

Note: Carla on Windows and macOS don't have this "Escape" key probem with the LV2. "Send all keyboard input to plug-in" seems to have no effect.

## Miscellaneous hosts

In some hosts, you first need to start the host's sequencer before any processing occurs. If VMPC2000XL is not making any sound, and its sequencer won't start, first try to hit the play button in your DAW. Logic and GarageBand are known to sometimes require this, and other hosts may have a similar requirement.
