;
; Ullrich von Bassewitz, 1998-08-06, 2009-09-26
;
; void __fastcall__ cputcxy (unsigned char x, unsigned char y, char c);
; void __fastcall__ cputc (char c);
;
; Important note: The implementation of cputs() relies on the cputc() function
; not clobbering ptr1. Beware when rewriting or changing this function!

        .export         _cputcxy, _cputc, cputdirect, putchar
        .export         newline, plot
        .import         gotoxy
        .import         PLOT
        .importzp       ptr4

        .include        "c65.inc"

_cputcxy:
        pha                     ; Save C
        jsr     gotoxy          ; Set cursor, drop x and y
        pla                     ; Restore C

; Plot a character - also used as internal function

_cputc: cmp     #$0A            ; CR?
        bne     L1
        lda     #0
        sta     CURS_X
        beq     plot            ; Recalculate pointers

L1:     cmp     #$0D            ; LF?
        beq     newline         ; Recalculate pointers

; Printable char of some sort

        cmp     #' '
        bcc     cputdirect      ; Other control char
        tay
        bmi     L10
        cmp     #$60
        bcc     L2
        and     #$DF
        bne     cputdirect      ; Branch always
L2:     and     #$3F

cputdirect:
        jsr     putchar         ; Write the character to the screen

; Advance cursor position

advance:
        iny
        cpy     #XSIZE
        bne     L3
        jsr     newline         ; new line
        ldy     #0              ; + cr
L3:     sty     CURS_X
        rts

newline:
        clc
        lda     #XSIZE
        adc     SCREEN_PTR
        sta     SCREEN_PTR
        bcc     L4
        inc     SCREEN_PTR+1
        clc
L4:     lda     #XSIZE
        adc     CRAM_PTR
        sta     CRAM_PTR
        bcc     L5
        inc     CRAM_PTR+1
L5:     inc     CURS_Y
        rts

; Handle character if high bit set

L10:    and     #$7F
        cmp     #$7F            ; PI?
        bne     L11
        lda     #$5E            ; Load screen code for PI
L11:    ora     #$40
        bne     cputdirect



; Set cursor position, calculate RAM pointers.

plot:   ldy     CURS_X
        ldx     CURS_Y
        clc
        jmp     PLOT            ; Set the new cursor



; Write one character to the screen without doing anything else, return X
; position in Y

putchar:
        ora     RVS             ; Set revers bit

        tay
        lda     SCREEN_PTR + 1
        clc
        adc     #>$0800
        sta     ptr4 + 1
        lda     SCREEN_PTR
        sta     ptr4
        tya

        ldy     CURS_X
        sta     (ptr4),y  ; Set char

        lda     ptr4 + 1
        clc
        adc     #>$d000
        sta     ptr4 + 1

        lda     CHARCOLOR
        sta     (ptr4),y    ; Set color

        rts
