--------------------------------------------------------------------------------
--
-- CTU CAN FD IP Core
-- Copyright (C) 2021-present Ondrej Ille
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this VHDL component and associated documentation files (the "Component"),
-- to use, copy, modify, merge, publish, distribute the Component for
-- educational, research, evaluation, self-interest purposes. Using the
-- Component for commercial purposes is forbidden unless previously agreed with
-- Copyright holder.
--
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Component.
--
-- THE COMPONENT IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHTHOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
-- FROM, OUT OF OR IN CONNECTION WITH THE COMPONENT OR THE USE OR OTHER DEALINGS
-- IN THE COMPONENT.
--
-- The CAN protocol is developed by Robert Bosch GmbH and protected by patents.
-- Anybody who wants to implement this IP core on silicon has to obtain a CAN
-- protocol license from Bosch.
--
-- -------------------------------------------------------------------------------
--
-- CTU CAN FD IP Core
-- Copyright (C) 2015-2020 MIT License
--
-- Authors:
--     Ondrej Ille <ondrej.ille@gmail.com>
--     Martin Jerabek <martin.jerabek01@gmail.com>
--
-- Project advisors:
-- 	Jiri Novak <jnovak@fel.cvut.cz>
-- 	Pavel Pisa <pisa@cmp.felk.cvut.cz>
--
-- Department of Measurement         (http://meas.fel.cvut.cz/)
-- Faculty of Electrical Engineering (http://www.fel.cvut.cz)
-- Czech Technical University        (http://www.cvut.cz/)
--
-- Permission is hereby granted, free of charge, to any person obtaining a copy
-- of this VHDL component and associated documentation files (the "Component"),
-- to deal in the Component without restriction, including without limitation
-- the rights to use, copy, modify, merge, publish, distribute, sublicense,
-- and/or sell copies of the Component, and to permit persons to whom the
-- Component is furnished to do so, subject to the following conditions:
--
-- The above copyright notice and this permission notice shall be included in
-- all copies or substantial portions of the Component.
--
-- THE COMPONENT IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
-- FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
-- AUTHORS OR COPYRIGHTHOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
-- LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
-- FROM, OUT OF OR IN CONNECTION WITH THE COMPONENT OR THE USE OR OTHER DEALINGS
-- IN THE COMPONENT.
--
-- The CAN protocol is developed by Robert Bosch GmbH and protected by patents.
-- Anybody who wants to implement this IP core on silicon has to obtain a CAN
-- protocol license from Bosch.
--
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- @TestInfoStart
--
-- @Purpose:
--  RX Buffer empty - read feature test
--
-- @Verifies:
--  @1. Verifies that when reading from empty RX Buffer, RX pointer is not
--      incremented!
--
-- @Test sequence:
--  @1. Read pointers from RX Buffer, check pointers are 0 (DUT is post reset).
--  @2. Try to read CAN frame from RX Buffer. This should generate at least 4
--      reads from RX DATA register.
--  @3. Read pointers from RX Buffer, check pointers are still 0.
--
-- @TestInfoEnd
--------------------------------------------------------------------------------
-- Revision History:
--    18.10.2019   Created file
--------------------------------------------------------------------------------

Library ctu_can_fd_tb;
context ctu_can_fd_tb.ieee_context;
context ctu_can_fd_tb.rtl_context;
context ctu_can_fd_tb.tb_common_context;

use ctu_can_fd_tb.feature_test_agent_pkg.all;

package rx_buf_empty_read_ftest is
    procedure rx_buf_empty_read_ftest_exec(
        signal      chn             : inout  t_com_channel
    );
end package;


package body rx_buf_empty_read_ftest is
    procedure rx_buf_empty_read_ftest_exec(
        signal      chn             : inout  t_com_channel
    ) is
        -- Generated frames
        variable frame_rx           :     SW_CAN_frame_type;
        variable rx_buf_info        :     SW_RX_Buffer_info;
        variable rx_data            :     std_logic_vector(31 downto 0);
    begin

        -----------------------------------------------------------------------
        -- @1. Read pointers from RX Buffer, check pointers are 0 (DUT is post
        --     reset).
        -----------------------------------------------------------------------
        info_m("Step 1: Reading RX buffer pointers for first time");

        get_rx_buf_state(rx_buf_info, DUT_NODE, chn);
        check_m(rx_buf_info.rx_read_pointer = 0, "Read pointer 0!");
        check_m(rx_buf_info.rx_write_pointer = 0, "Write pointer 0!");

        -----------------------------------------------------------------------
        -- @2. Try to read CAN frame from RX Buffer. This should generate at
        --     least 4 reads from RX DATA register.
        -----------------------------------------------------------------------
        info_m("Step 2: Try to read frame from empty RX Buffer!");

        -- Use purposefully "raw" reads instead of CAN_Read_frame
        CAN_read(rx_data, RX_DATA_ADR, DUT_NODE, chn);
        CAN_read(rx_data, RX_DATA_ADR, DUT_NODE, chn);
        CAN_read(rx_data, RX_DATA_ADR, DUT_NODE, chn);
        CAN_read(rx_data, RX_DATA_ADR, DUT_NODE, chn);

        ------------------------------------------------------------------------
        -- @3. Read pointers from RX Buffer, check pointers are still 0.
        ------------------------------------------------------------------------
        info_m("Step 3: Read RX Buffer pointers again!");
        get_rx_buf_state(rx_buf_info, DUT_NODE, chn);
        check_m(rx_buf_info.rx_read_pointer = 0, "Read pointer 0!");
        check_m(rx_buf_info.rx_write_pointer = 0, "Write pointer 0!");

  end procedure;

end package body;
