.TH "Simple Virtual Machine - Plugin config" 7 "2025-09-22"
.SH SYNOPSIS
.B svm_plugin_config
Configuration for applications
.SH DESCRIPTION
This plugin provides a configuration scheme for Simple Virtual Machine applications with light but versatile syntax.
.P
The configuration syntax:
 - Ignore all blank characters,
 - Ignore everything after a hash (#), treated as comment.
.P
The values within the configuration are organised in a tree where the root node is the inside part of an object (see below).
.P
Possible values:
 - Integers,
 - Strings (between double quotes (")),
 - Booleans (TRUE or FALSE),
 - Plugin Entry Points,
 - Plugin constant values.
.P
Two other types are accessibles:
 - References:
.nf
 $<identifier1>.<identifier2>. [...] .<identifiern>$
.fi
Written like above, this value references another value located at the path indicated between the two dollar ($) signs;
 - Objects:
    - Objects are delimited by curved brackets ({ at begining and } at end),
    - Objects are made of members written as <identifier>: <value>, without separator between members,
    - Each member name shall be unique within each object,
    - Each object is a node within the configuration tree.
.P
Within an object, some members can be added depending on conditions, written like (The ELSE part is optional):
.nf
CASE <condition1> THEN
	<members1>
	END
CASE <condition2> THEN
	<members2>
	END
[...]
CASE <conditionn> THEN
	<membersn>
	END
ELSE
	<members default>
	END
END
.fi
The conditions are made of identifiers as atoms, with the regular NOT, AND, OR and XOR boolean identifiers and the parenthesis for precedence.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmpluginconfig/libsvmconfig.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH CONTENT
.SS TYPE config.database
This type contains the parsed representation of the configuration.
It is build from the text representation of the configuration and can be queried from the SVM code.
.SS INTERRUPTION config.invalid
This interruption is raised when the configuration text can not be parsed.
.SS INTERRUPTION config.invalid_file
This interruption is raised when the given name is not suitable for configuration build.
.SS SYSTEM INSTRUCTION config.read [ 'FILE' 'STR' ] STR:source ( PTR | { STR * } ):flags -> config.database
This instruction reads a string of a file and builds a configuration database.
.P
Either using a pointer to strings, or between curved brackets, some strings can be specified as flags.
Each flag passed to the instruction will turn to true each corresponding identifiers in conditions (After CASE keyword).
.P
It raises the interruption !config.invalid_file when a file is specified, but can not be read.
It raises the interruption !config.invalid when the syntax of the config text is invalid.
.SS SYSTEM INSTRUCTION config.merge ( PTR | config.database config.database + ) -> config.database
This instruction merges several configuration databases in one.
.P
Each object in the merged configuration database contains the union of the object members.
On conflict (same member at the same object), the more recent value is used.
.P
This instruction can be used as a template engine where the first database is the canvas, and others are customised values within the canvas.
.SS INSTRUCTION config.value config.database ( PTR | < STR * > ) ( 'DEFAULT' VALUE ) ? -> VALUE ?
This instruction is the main configuration database query.
.P
It retrieves the value within the given database at the specified path.
.P
If a default value is specified, it is returned when the value is not available in the database, or a null value if no default value has been specified.
.SS FUNCTION config.value config.database ( PTR | < STR * > ) ( 'DEFAULT' VALUE ) ? -> VALUE
This function provides the same functionality as the instruction :config.value with one difference: When the path corresponds to no value, an empty string is returned instead.
.SS INSTRUCTION config.array config.database ( PTR | < STR * > ) -> PTR ?
This instruction returns values from an object in the configuration, and returns them like an array.
.P
Object members are written in the lexical order of their identifier.
References are followed to find the real value behind the reference, and references pointing to no value are ignored.
Embedded objects are recursively used.
.P
The values are written into memory as single block and the pointer to the values is returned by the instruction.
.SS INSTRUCTION config.find config.database STR -> PTR
This instruction returns all paths terminated by the given name as member.
.P
Each path is represented as an array of strings where the last one is equal to the one provided as search criteria.
.SH EXAMPLE
.SS URL configuration
Template configuration (config.svm_cfg):
.nf
config:
{
	url:
	{
		protocol: "https"
		host: $values.url.host$
		port: 80
		resource: "index.html"
	}
}
.fi

Values (values.svm_cfg):
.nf
values:
{
	url:
	{
		host: "www.example.com"
	}
}
# Override
config:
{
	url:
	{
		CASE test THEN
			port: 8080
			END
		CASE local THEN
			protocol: "http"
			port: 33000
			END
		END
	}
}
.fi

Code (open_url.svm):
.nf
#!/usr/bin/env svm
LOG

PLUGIN "svmcom.so"
PLUGIN "svmstr.so"
PLUGIN "===PLUGINLIB==="

ARGUMENT STR environment

PROCESS "url"
	CODE "main" INLINE
		:memory config.database*2/c, STR/s
		:config.read FILE "config.svm_cfg" { @&environment } -> &c
		:config.read FILE "values.svm_cfg" { @&environment } -> (c/1)
		:config.merge @&c @(c/1) -> &c
		:str.format { config.value @&c < "config" "url" "protocol" > } "://" { config.value @&c < "config" "url" "host" > } ":" { config.value @&c < "config" "url" "port" > } "/" { config.value @&c < "config" "url" "resource" > } -> &s
		:com.message @&s
	END
	MEMORY environment
END
.fi
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
