" 
" Simple Virtual Machine - A versatile and robust architecture to
" easily write applications.
" Copyright (C) 2021  Julien BRUGUIER
" 
" This program is free software: you can redistribute it and/or modify
" it under the terms of the GNU General Public License as published by
" the Free Software Foundation, either version 3 of the License, or
" (at your option) any later version.
" 
" This program is distributed in the hope that it will be useful,
" but WITHOUT ANY WARRANTY; without even the implied warranty of
" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
" GNU General Public License for more details.
" 
" You should have received a copy of the GNU General Public License
" along with this program.  If not, see <http://www.gnu.org/licenses/>.
" 
syn clear
syn keyword Todo PACKAGE
syn keyword Environnement LICENSE
syn keyword Environnement SHELL
syn keyword Environnement END
syn match Name "[a-z][a-z0-9_]*" contained
syn keyword PackageMetaCommand OPTION contained
syn keyword PackageMetaCommand SET contained
syn keyword PackageMetaCommand VAR contained

syn keyword PackageCommand APP
syn keyword PackageCommand LIB
syn keyword PackageCommand PLUGIN
syn keyword PackageCommand FILE
syn keyword PackageCommand DIR

syn keyword PackageCondition IF
syn keyword PackageCondition FI

syn keyword PackageConditionOperator NOT
syn keyword PackageConditionOperator AND
syn keyword PackageConditionOperator OR
syn keyword PackageConditionOperator XOR
syn match PackageConditionOperator "[()]"

syn keyword YesValue YES contained
syn keyword NoValue NO contained
syn keyword DefaultValue DEFAULT contained
syn match Constant "\"[^"]*\"" contained
syn match Constant "[0-9]\+" contained

syn match OptionCommand "^OPTION[ \t]*[a-z][a-z0-9_]*" contains=PackageMetaCommand,Name
syn match OptionCommandFull "^OPTION.*" contains=OptionCommand,Constant,YesValue,NoValue,DefaultValue

syn match SetCommand "^SET[ \t]*[a-z][a-z0-9_]*" contains=PackageMetaCommand,Name
syn match SetCommandFull "^SET.*" contains=SetCommand,Constant,YesValue,NoValue,DefaultValue

syn match VariableCommandFull "^VAR.*" contains=PackageMetaCommand,Constant,YesValue,NoValue,DefaultValue

syn match Comment "#.*"

hi def link Environnement Conceal
hi def link PackageCommand Keyword
hi def link PackageMetaCommand Special
hi def link Name Type
hi def link YesValue MatchParen
hi def link NoValue Error
hi def link DefaultValue Todo
hi def link PackageCondition Identifier
hi def link PackageConditionOperator Identifier
