/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.jaxen.expr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import nu.xom.jaxen.Context;
import nu.xom.jaxen.ContextSupport;
import nu.xom.jaxen.JaxenException;
import nu.xom.jaxen.expr.Predicate;
import nu.xom.jaxen.function.BooleanFunction;

public class PredicateSet
implements Serializable {
    private static final long serialVersionUID = -7166491740228977853L;
    private List predicates = Collections.EMPTY_LIST;

    public void addPredicate(Predicate predicate) {
        if (this.predicates == Collections.EMPTY_LIST) {
            this.predicates = new ArrayList();
        }
        this.predicates.add(predicate);
    }

    public List getPredicates() {
        return this.predicates;
    }

    public void simplify() {
        Iterator iterator = this.predicates.iterator();
        Predicate predicate = null;
        while (iterator.hasNext()) {
            predicate = (Predicate)iterator.next();
            predicate.simplify();
        }
    }

    public String getText() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.predicates.iterator();
        Predicate predicate = null;
        while (iterator.hasNext()) {
            predicate = (Predicate)iterator.next();
            stringBuffer.append(predicate.getText());
        }
        return stringBuffer.toString();
    }

    protected boolean evaluateAsBoolean(List list, ContextSupport contextSupport) throws JaxenException {
        return this.anyMatchingNode(list, contextSupport);
    }

    private boolean anyMatchingNode(List list, ContextSupport contextSupport) throws JaxenException {
        if (this.predicates.size() == 0) {
            return false;
        }
        Iterator iterator = this.predicates.iterator();
        List list2 = list;
        while (iterator.hasNext()) {
            int n = list2.size();
            Context context = new Context(contextSupport);
            ArrayList arrayList = new ArrayList(1);
            context.setNodeSet(arrayList);
            for (int i = 0; i < n; ++i) {
                Boolean bl;
                int n2;
                Object e = list2.get(i);
                arrayList.clear();
                arrayList.add(e);
                context.setNodeSet(arrayList);
                context.setPosition(i + 1);
                context.setSize(n);
                Object object = ((Predicate)iterator.next()).evaluate(context);
                if (!(object instanceof Number ? (n2 = ((Number)object).intValue()) == i + 1 : (bl = BooleanFunction.evaluate(object, context.getNavigator())) != false)) continue;
                return true;
            }
        }
        return false;
    }

    protected List evaluatePredicates(List list, ContextSupport contextSupport) throws JaxenException {
        if (this.predicates.size() == 0) {
            return list;
        }
        Iterator iterator = this.predicates.iterator();
        List list2 = list;
        while (iterator.hasNext()) {
            list2 = this.applyPredicate((Predicate)iterator.next(), list2, contextSupport);
        }
        return list2;
    }

    public List applyPredicate(Predicate predicate, List list, ContextSupport contextSupport) throws JaxenException {
        int n = list.size();
        ArrayList arrayList = new ArrayList(n);
        Context context = new Context(contextSupport);
        ArrayList arrayList2 = new ArrayList(1);
        context.setNodeSet(arrayList2);
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            arrayList2.clear();
            arrayList2.add(e);
            context.setNodeSet(arrayList2);
            context.setPosition(i + 1);
            context.setSize(n);
            Object object = predicate.evaluate(context);
            if (object instanceof Number) {
                int n2 = ((Number)object).intValue();
                if (n2 != i + 1) continue;
                arrayList.add(e);
                continue;
            }
            Boolean bl = BooleanFunction.evaluate(object, context.getNavigator());
            if (!bl.booleanValue()) continue;
            arrayList.add(e);
        }
        return arrayList;
    }
}

