/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.jfr.jdk9.model.impl;

import java.io.File;
import java.io.IOException;
import org.graalvm.visualvm.core.model.ModelProvider;
import org.graalvm.visualvm.jfr.jdk9.model.impl.JFRJDK9Model;
import org.graalvm.visualvm.jfr.model.JFRModel;
import org.graalvm.visualvm.jfr.model.JFRModelFactory;
import org.graalvm.visualvm.jfr.model.JFRModelProvider;

public final class JFRJDK9ModelProvider
extends JFRModelProvider {
    private static Boolean IS_ACTIVE;

    private JFRJDK9ModelProvider() {
        super("JDK9 loader", 100);
    }

    public static void register() {
        JFRModelFactory.getDefault().registerProvider((ModelProvider)new JFRJDK9ModelProvider());
    }

    protected JFRModel createModel(String id, File file) throws IOException {
        return JFRJDK9ModelProvider.isActive() ? new JFRJDK9Model(id, file) : null;
    }

    private static boolean isActive() {
        if (IS_ACTIVE == null) {
            String javaVersion = System.getProperty("java.version");
            if (javaVersion != null && (javaVersion.equals("9") || javaVersion.startsWith("9.") || javaVersion.equals("10") || javaVersion.startsWith("10."))) {
                IS_ACTIVE = Boolean.TRUE;
            }
            if (IS_ACTIVE == null) {
                IS_ACTIVE = Boolean.FALSE;
            }
        }
        return IS_ACTIVE;
    }
}

