"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolvedPath = void 0;
const extended_encode_uri_component_1 = require("./extended-encode-uri-component");
const resolvedPath = (resolvedPath, input, memberName, labelValueProvider, uriLabel, isGreedyLabel) => {
    if (input != null && input[memberName] !== undefined) {
        const labelValue = labelValueProvider();
        if (labelValue.length <= 0) {
            throw new Error("Empty value provided for input HTTP label: " + memberName + ".");
        }
        resolvedPath = resolvedPath.replace(uriLabel, isGreedyLabel
            ? labelValue
                .split("/")
                .map((segment) => (0, extended_encode_uri_component_1.extendedEncodeURIComponent)(segment))
                .join("/")
            : (0, extended_encode_uri_component_1.extendedEncodeURIComponent)(labelValue));
    }
    else {
        throw new Error("No value provided for input HTTP label: " + memberName + ".");
    }
    return resolvedPath;
};
exports.resolvedPath = resolvedPath;
