/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.implementation.ImplUtils;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.Context;
import com.azure.core.util.Header;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public final class CoreUtils {
    private static final ClientLogger LOGGER = new ClientLogger(CoreUtils.class);
    private static final char[] LOWERCASE_HEX_CHARACTERS = "0123456789abcdef".toCharArray();

    private CoreUtils() {
    }

    public static byte[] clone(byte[] source) {
        if (source == null) {
            return null;
        }
        byte[] copy = new byte[source.length];
        System.arraycopy(source, 0, copy, 0, source.length);
        return copy;
    }

    public static int[] clone(int[] source) {
        if (source == null) {
            return null;
        }
        int[] copy = new int[source.length];
        System.arraycopy(source, 0, copy, 0, source.length);
        return copy;
    }

    public static <T> T[] clone(T[] source) {
        if (source == null) {
            return null;
        }
        return Arrays.copyOf(source, source.length);
    }

    public static boolean isNullOrEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNullOrEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static <T> String arrayToString(T[] array, Function<T, String> mapper) {
        if (CoreUtils.isNullOrEmpty(array)) {
            return null;
        }
        return Arrays.stream(array).map(mapper).collect(Collectors.joining(","));
    }

    public static <T> T findFirstOfType(Object[] args, Class<T> clazz) {
        if (CoreUtils.isNullOrEmpty(args)) {
            return null;
        }
        for (Object arg : args) {
            if (!clazz.isInstance(arg)) continue;
            return clazz.cast(arg);
        }
        return null;
    }

    @Deprecated
    public static <T> Publisher<T> extractAndFetch(PagedResponse<T> page, Context context, BiFunction<String, Context, Publisher<T>> content) {
        String nextPageLink = (String)page.getContinuationToken();
        if (nextPageLink == null) {
            return Flux.fromIterable(page.getElements());
        }
        return Flux.fromIterable(page.getElements()).concatWith(content.apply(nextPageLink, context));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getProperties(String propertiesFileName) {
        try (InputStream inputStream = CoreUtils.class.getClassLoader().getResourceAsStream(propertiesFileName);){
            if (inputStream == null) return Collections.emptyMap();
            Properties properties = new Properties();
            properties.load(inputStream);
            Map<String, String> map = Collections.unmodifiableMap(properties.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue())));
            return map;
        }
        catch (IOException ex) {
            LOGGER.warning("Failed to get properties from " + propertiesFileName, ex);
        }
        return Collections.emptyMap();
    }

    public static String bomAwareToString(byte[] bytes, String contentType) {
        if (bytes == null) {
            return null;
        }
        return ImplUtils.bomAwareToString(bytes, 0, bytes.length, contentType);
    }

    public static String getApplicationId(ClientOptions clientOptions, HttpLogOptions logOptions) {
        if (clientOptions != null && !CoreUtils.isNullOrEmpty(clientOptions.getApplicationId())) {
            return clientOptions.getApplicationId();
        }
        if (logOptions != null && !CoreUtils.isNullOrEmpty(logOptions.getApplicationId())) {
            return logOptions.getApplicationId();
        }
        return null;
    }

    public static HttpHeaders createHttpHeadersFromClientOptions(ClientOptions clientOptions) {
        if (clientOptions == null) {
            return null;
        }
        Iterator<Header> headerIterator = clientOptions.getHeaders().iterator();
        if (!headerIterator.hasNext()) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        do {
            Header header = headerIterator.next();
            headers.set(header.getName(), header.getValue());
        } while (headerIterator.hasNext());
        return headers;
    }

    public static Duration getDefaultTimeoutFromEnvironment(Configuration configuration, String timeoutPropertyName, Duration defaultTimeout, ClientLogger logger) {
        String environmentTimeout = configuration.get(timeoutPropertyName);
        if (CoreUtils.isNullOrEmpty(environmentTimeout)) {
            return defaultTimeout;
        }
        try {
            long timeoutMillis = Long.parseLong(environmentTimeout);
            if (timeoutMillis < 0L) {
                logger.atVerbose().addKeyValue(timeoutPropertyName, timeoutMillis).log("Negative timeout values are not allowed. Using 'Duration.ZERO' to indicate no timeout.");
                return Duration.ZERO;
            }
            return Duration.ofMillis(timeoutMillis);
        }
        catch (NumberFormatException ex) {
            logger.atWarning().addKeyValue(timeoutPropertyName, environmentTimeout).addKeyValue("defaultTimeout", defaultTimeout).log("Timeout is not valid number. Using default value.", ex);
            return defaultTimeout;
        }
    }

    public static Context mergeContexts(Context into, Context from) {
        Objects.requireNonNull(into, "'into' cannot be null.");
        Objects.requireNonNull(from, "'from' cannot be null.");
        if (into == Context.NONE) {
            return from;
        }
        if (from == Context.NONE) {
            return into;
        }
        Context[] contextChain = from.getContextChain();
        Context returnContext = into;
        for (Context toAdd : contextChain) {
            if (toAdd == null) continue;
            returnContext = returnContext.addData(toAdd.getKey(), toAdd.getValue());
        }
        return returnContext;
    }

    public static String stringJoin(String delimiter, List<String> values) {
        Objects.requireNonNull(delimiter, "'delimiter' cannot be null.");
        Objects.requireNonNull(values, "'values' cannot be null.");
        int count = values.size();
        switch (count) {
            case 0: {
                return "";
            }
            case 1: {
                return values.get(0);
            }
            case 2: {
                return values.get(0) + delimiter + values.get(1);
            }
            case 3: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2);
            }
            case 4: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3);
            }
            case 5: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3) + delimiter + values.get(4);
            }
            case 6: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3) + delimiter + values.get(4) + delimiter + values.get(5);
            }
            case 7: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3) + delimiter + values.get(4) + delimiter + values.get(5) + delimiter + values.get(6);
            }
            case 8: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3) + delimiter + values.get(4) + delimiter + values.get(5) + delimiter + values.get(6) + delimiter + values.get(7);
            }
            case 9: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3) + delimiter + values.get(4) + delimiter + values.get(5) + delimiter + values.get(6) + delimiter + values.get(7) + delimiter + values.get(8);
            }
            case 10: {
                return values.get(0) + delimiter + values.get(1) + delimiter + values.get(2) + delimiter + values.get(3) + delimiter + values.get(4) + delimiter + values.get(5) + delimiter + values.get(6) + delimiter + values.get(7) + delimiter + values.get(8) + delimiter + values.get(9);
            }
        }
        return String.join((CharSequence)delimiter, values);
    }

    public static String bytesToHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return "";
        }
        char[] hexString = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            hexString[i * 2] = LOWERCASE_HEX_CHARACTERS[b >>> 4];
            hexString[i * 2 + 1] = LOWERCASE_HEX_CHARACTERS[b & 0xF];
        }
        return new String(hexString);
    }

    public static long extractSizeFromContentRange(String contentRange) {
        Objects.requireNonNull(contentRange, "Cannot extract length from null 'contentRange'.");
        int index = contentRange.indexOf(47);
        if (index == -1) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("The Content-Range header wasn't properly formatted and didn't contain a '/size' segment. The 'contentRange' was: " + contentRange));
        }
        String sizeString = contentRange.substring(index + 1).trim();
        if ("*".equals(sizeString)) {
            return -1L;
        }
        return Long.parseLong(sizeString);
    }

    public static Iterator<Map.Entry<String, String>> parseQueryParameters(String queryParameters) {
        return CoreUtils.isNullOrEmpty(queryParameters) ? Collections.emptyIterator() : new ImplUtils.QueryParameterIterator(queryParameters);
    }
}

