/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.opensearch.neuralsearch.query.HybridQuery;
import org.opensearch.neuralsearch.query.HybridQueryScorer;

public final class HybridQueryWeight
extends Weight {
    private final HybridQuery queries;
    private final List<Weight> weights;
    private final ScoreMode scoreMode;

    public HybridQueryWeight(HybridQuery hybridQuery, IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        super((Query)hybridQuery);
        this.queries = hybridQuery;
        this.weights = hybridQuery.getSubQueries().stream().map(q -> {
            try {
                return searcher.createWeight(q, scoreMode, boost);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        this.scoreMode = scoreMode;
    }

    public Matches matches(LeafReaderContext context, int doc) throws IOException {
        List mis = this.weights.stream().map(weight -> {
            try {
                return weight.matches(context, doc);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return MatchesUtils.fromSubMatches(mis);
    }

    public Scorer scorer(LeafReaderContext context) throws IOException {
        List<Scorer> scorers = this.weights.stream().map(w -> {
            try {
                return w.scorer(context);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        if (scorers.stream().allMatch(Objects::isNull)) {
            return null;
        }
        return new HybridQueryScorer(this, scorers);
    }

    public boolean isCacheable(LeafReaderContext ctx) {
        return this.weights.stream().allMatch(w -> w.isCacheable(ctx));
    }

    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        throw new UnsupportedOperationException("Explain is not supported");
    }
}

