/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.opensearch.index.fielddata.LeafFieldData;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.knn.index.KNNVectorScriptDocValues;
import org.opensearch.knn.index.VectorDataType;

public class KNNVectorDVLeafFieldData
implements LeafFieldData {
    private final LeafReader reader;
    private final String fieldName;
    private final VectorDataType vectorDataType;

    public KNNVectorDVLeafFieldData(LeafReader reader, String fieldName, VectorDataType vectorDataType) {
        this.reader = reader;
        this.fieldName = fieldName;
        this.vectorDataType = vectorDataType;
    }

    public void close() {
    }

    public long ramBytesUsed() {
        return 0L;
    }

    public ScriptDocValues<float[]> getScriptValues() {
        try {
            BinaryDocValues values = DocValues.getBinary((LeafReader)this.reader, (String)this.fieldName);
            return new KNNVectorScriptDocValues(values, this.fieldName, this.vectorDataType);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values for knn vector field: " + this.fieldName, e);
        }
    }

    public SortedBinaryDocValues getBytesValues() {
        throw new UnsupportedOperationException("knn vector field '" + this.fieldName + "' doesn't support sorting");
    }
}

