/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityRequest;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstanceAvailabilityResponse;
import software.amazon.awssdk.services.ec2.model.ScheduledInstanceAvailability;

public class DescribeScheduledInstanceAvailabilityPublisher
implements SdkPublisher<DescribeScheduledInstanceAvailabilityResponse> {
    private final Ec2AsyncClient client;
    private final DescribeScheduledInstanceAvailabilityRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeScheduledInstanceAvailabilityPublisher(Ec2AsyncClient client, DescribeScheduledInstanceAvailabilityRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeScheduledInstanceAvailabilityPublisher(Ec2AsyncClient client, DescribeScheduledInstanceAvailabilityRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeScheduledInstanceAvailabilityResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeScheduledInstanceAvailabilityResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScheduledInstanceAvailability> scheduledInstanceAvailabilitySet() {
        Function<DescribeScheduledInstanceAvailabilityResponse, Iterator> getIterator = response -> {
            if (response != null && response.scheduledInstanceAvailabilitySet() != null) {
                return response.scheduledInstanceAvailabilitySet().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeScheduledInstanceAvailabilityResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeScheduledInstanceAvailabilityResponseFetcher
    implements AsyncPageFetcher<DescribeScheduledInstanceAvailabilityResponse> {
        private DescribeScheduledInstanceAvailabilityResponseFetcher() {
        }

        public boolean hasNextPage(DescribeScheduledInstanceAvailabilityResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeScheduledInstanceAvailabilityResponse> nextPage(DescribeScheduledInstanceAvailabilityResponse previousPage) {
            if (previousPage == null) {
                return DescribeScheduledInstanceAvailabilityPublisher.this.client.describeScheduledInstanceAvailability(DescribeScheduledInstanceAvailabilityPublisher.this.firstRequest);
            }
            return DescribeScheduledInstanceAvailabilityPublisher.this.client.describeScheduledInstanceAvailability((DescribeScheduledInstanceAvailabilityRequest)((Object)DescribeScheduledInstanceAvailabilityPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

