/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifiedAccessGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VerifiedAccessGroup> {
    private static final SdkField<String> VERIFIED_ACCESS_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessGroupId").getter(VerifiedAccessGroup.getter(VerifiedAccessGroup::verifiedAccessGroupId)).setter(VerifiedAccessGroup.setter(Builder::verifiedAccessGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessGroupId").unmarshallLocationName("verifiedAccessGroupId").build()}).build();
    private static final SdkField<String> VERIFIED_ACCESS_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessInstanceId").getter(VerifiedAccessGroup.getter(VerifiedAccessGroup::verifiedAccessInstanceId)).setter(VerifiedAccessGroup.setter(Builder::verifiedAccessInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessInstanceId").unmarshallLocationName("verifiedAccessInstanceId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(VerifiedAccessGroup.getter(VerifiedAccessGroup::description)).setter(VerifiedAccessGroup.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Owner").getter(VerifiedAccessGroup.getter(VerifiedAccessGroup::owner)).setter(VerifiedAccessGroup.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").unmarshallLocationName("owner").build()}).build();
    private static final SdkField<String> VERIFIED_ACCESS_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VerifiedAccessGroupArn").getter(VerifiedAccessGroup.getter(VerifiedAccessGroup::verifiedAccessGroupArn)).setter(VerifiedAccessGroup.setter(Builder::verifiedAccessGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessGroupArn").unmarshallLocationName("verifiedAccessGroupArn").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(VerifiedAccessGroup.getter(VerifiedAccessGroup::creationTime)).setter(VerifiedAccessGroup.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").unmarshallLocationName("creationTime").build()}).build();
    private static final SdkField<String> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUpdatedTime").getter(VerifiedAccessGroup.getter(VerifiedAccessGroup::lastUpdatedTime)).setter(VerifiedAccessGroup.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").unmarshallLocationName("lastUpdatedTime").build()}).build();
    private static final SdkField<String> DELETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeletionTime").getter(VerifiedAccessGroup.getter(VerifiedAccessGroup::deletionTime)).setter(VerifiedAccessGroup.setter(Builder::deletionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionTime").unmarshallLocationName("deletionTime").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(VerifiedAccessGroup.getter(VerifiedAccessGroup::tags)).setter(VerifiedAccessGroup.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_GROUP_ID_FIELD, VERIFIED_ACCESS_INSTANCE_ID_FIELD, DESCRIPTION_FIELD, OWNER_FIELD, VERIFIED_ACCESS_GROUP_ARN_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, DELETION_TIME_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String verifiedAccessGroupId;
    private final String verifiedAccessInstanceId;
    private final String description;
    private final String owner;
    private final String verifiedAccessGroupArn;
    private final String creationTime;
    private final String lastUpdatedTime;
    private final String deletionTime;
    private final List<Tag> tags;

    private VerifiedAccessGroup(BuilderImpl builder) {
        this.verifiedAccessGroupId = builder.verifiedAccessGroupId;
        this.verifiedAccessInstanceId = builder.verifiedAccessInstanceId;
        this.description = builder.description;
        this.owner = builder.owner;
        this.verifiedAccessGroupArn = builder.verifiedAccessGroupArn;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.deletionTime = builder.deletionTime;
        this.tags = builder.tags;
    }

    public final String verifiedAccessGroupId() {
        return this.verifiedAccessGroupId;
    }

    public final String verifiedAccessInstanceId() {
        return this.verifiedAccessInstanceId;
    }

    public final String description() {
        return this.description;
    }

    public final String owner() {
        return this.owner;
    }

    public final String verifiedAccessGroupArn() {
        return this.verifiedAccessGroupArn;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final String lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final String deletionTime() {
        return this.deletionTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.verifiedAccessGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessGroup)) {
            return false;
        }
        VerifiedAccessGroup other = (VerifiedAccessGroup)obj;
        return Objects.equals(this.verifiedAccessGroupId(), other.verifiedAccessGroupId()) && Objects.equals(this.verifiedAccessInstanceId(), other.verifiedAccessInstanceId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.verifiedAccessGroupArn(), other.verifiedAccessGroupArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.deletionTime(), other.deletionTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"VerifiedAccessGroup").add("VerifiedAccessGroupId", (Object)this.verifiedAccessGroupId()).add("VerifiedAccessInstanceId", (Object)this.verifiedAccessInstanceId()).add("Description", (Object)this.description()).add("Owner", (Object)this.owner()).add("VerifiedAccessGroupArn", (Object)this.verifiedAccessGroupArn()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("DeletionTime", (Object)this.deletionTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedAccessGroupId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessGroupId()));
            }
            case "VerifiedAccessInstanceId": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessInstanceId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "VerifiedAccessGroupArn": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessGroupArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "DeletionTime": {
                return Optional.ofNullable(clazz.cast(this.deletionTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessGroup, T> g) {
        return obj -> g.apply((VerifiedAccessGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String verifiedAccessGroupId;
        private String verifiedAccessInstanceId;
        private String description;
        private String owner;
        private String verifiedAccessGroupArn;
        private String creationTime;
        private String lastUpdatedTime;
        private String deletionTime;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessGroup model) {
            this.verifiedAccessGroupId(model.verifiedAccessGroupId);
            this.verifiedAccessInstanceId(model.verifiedAccessInstanceId);
            this.description(model.description);
            this.owner(model.owner);
            this.verifiedAccessGroupArn(model.verifiedAccessGroupArn);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.deletionTime(model.deletionTime);
            this.tags(model.tags);
        }

        public final String getVerifiedAccessGroupId() {
            return this.verifiedAccessGroupId;
        }

        public final void setVerifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
        }

        @Override
        public final Builder verifiedAccessGroupId(String verifiedAccessGroupId) {
            this.verifiedAccessGroupId = verifiedAccessGroupId;
            return this;
        }

        public final String getVerifiedAccessInstanceId() {
            return this.verifiedAccessInstanceId;
        }

        public final void setVerifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
        }

        @Override
        public final Builder verifiedAccessInstanceId(String verifiedAccessInstanceId) {
            this.verifiedAccessInstanceId = verifiedAccessInstanceId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getVerifiedAccessGroupArn() {
            return this.verifiedAccessGroupArn;
        }

        public final void setVerifiedAccessGroupArn(String verifiedAccessGroupArn) {
            this.verifiedAccessGroupArn = verifiedAccessGroupArn;
        }

        @Override
        public final Builder verifiedAccessGroupArn(String verifiedAccessGroupArn) {
            this.verifiedAccessGroupArn = verifiedAccessGroupArn;
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(String lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getDeletionTime() {
            return this.deletionTime;
        }

        public final void setDeletionTime(String deletionTime) {
            this.deletionTime = deletionTime;
        }

        @Override
        public final Builder deletionTime(String deletionTime) {
            this.deletionTime = deletionTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public VerifiedAccessGroup build() {
            return new VerifiedAccessGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VerifiedAccessGroup> {
        public Builder verifiedAccessGroupId(String var1);

        public Builder verifiedAccessInstanceId(String var1);

        public Builder description(String var1);

        public Builder owner(String var1);

        public Builder verifiedAccessGroupArn(String var1);

        public Builder creationTime(String var1);

        public Builder lastUpdatedTime(String var1);

        public Builder deletionTime(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

