/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.GroupIdentifierListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceIpv4Prefix;
import software.amazon.awssdk.services.ec2.model.InstanceIpv4PrefixListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Address;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6AddressListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6Prefix;
import software.amazon.awssdk.services.ec2.model.InstanceIpv6PrefixListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAssociation;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceAttachment;
import software.amazon.awssdk.services.ec2.model.InstancePrivateIpAddress;
import software.amazon.awssdk.services.ec2.model.InstancePrivateIpAddressListCopier;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceNetworkInterface
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceNetworkInterface> {
    private static final SdkField<InstanceNetworkInterfaceAssociation> ASSOCIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Association").getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::association)).setter(InstanceNetworkInterface.setter(Builder::association)).constructor(InstanceNetworkInterfaceAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Association").unmarshallLocationName("association").build()}).build();
    private static final SdkField<InstanceNetworkInterfaceAttachment> ATTACHMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Attachment").getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::attachment)).setter(InstanceNetworkInterface.setter(Builder::attachment)).constructor(InstanceNetworkInterfaceAttachment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attachment").unmarshallLocationName("attachment").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::description)).setter(InstanceNetworkInterface.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<List<GroupIdentifier>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Groups").getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::groups)).setter(InstanceNetworkInterface.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupSet").unmarshallLocationName("groupSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<InstanceIpv6Address>> IPV6_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Addresses").getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::ipv6Addresses)).setter(InstanceNetworkInterface.setter(Builder::ipv6Addresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressesSet").unmarshallLocationName("ipv6AddressesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceIpv6Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> MAC_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MacAddress").getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::macAddress)).setter(InstanceNetworkInterface.setter(Builder::macAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacAddress").unmarshallLocationName("macAddress").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::networkInterfaceId)).setter(InstanceNetworkInterface.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::ownerId)).setter(InstanceNetworkInterface.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> PRIVATE_DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateDnsName").getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::privateDnsName)).setter(InstanceNetworkInterface.setter(Builder::privateDnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsName").unmarshallLocationName("privateDnsName").build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateIpAddress").getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::privateIpAddress)).setter(InstanceNetworkInterface.setter(Builder::privateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("privateIpAddress").build()}).build();
    private static final SdkField<List<InstancePrivateIpAddress>> PRIVATE_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PrivateIpAddresses").getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::privateIpAddresses)).setter(InstanceNetworkInterface.setter(Builder::privateIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddressesSet").unmarshallLocationName("privateIpAddressesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstancePrivateIpAddress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> SOURCE_DEST_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SourceDestCheck").getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::sourceDestCheck)).setter(InstanceNetworkInterface.setter(Builder::sourceDestCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDestCheck").unmarshallLocationName("sourceDestCheck").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::statusAsString)).setter(InstanceNetworkInterface.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetId").getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::subnetId)).setter(InstanceNetworkInterface.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("subnetId").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::vpcId)).setter(InstanceNetworkInterface.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").unmarshallLocationName("vpcId").build()}).build();
    private static final SdkField<String> INTERFACE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterfaceType").getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::interfaceType)).setter(InstanceNetworkInterface.setter(Builder::interfaceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceType").unmarshallLocationName("interfaceType").build()}).build();
    private static final SdkField<List<InstanceIpv4Prefix>> IPV4_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv4Prefixes").getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::ipv4Prefixes)).setter(InstanceNetworkInterface.setter(Builder::ipv4Prefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4PrefixSet").unmarshallLocationName("ipv4PrefixSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceIpv4Prefix::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<InstanceIpv6Prefix>> IPV6_PREFIXES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Ipv6Prefixes").getter(InstanceNetworkInterface.getter(InstanceNetworkInterface::ipv6Prefixes)).setter(InstanceNetworkInterface.setter(Builder::ipv6Prefixes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6PrefixSet").unmarshallLocationName("ipv6PrefixSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceIpv6Prefix::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_FIELD, ATTACHMENT_FIELD, DESCRIPTION_FIELD, GROUPS_FIELD, IPV6_ADDRESSES_FIELD, MAC_ADDRESS_FIELD, NETWORK_INTERFACE_ID_FIELD, OWNER_ID_FIELD, PRIVATE_DNS_NAME_FIELD, PRIVATE_IP_ADDRESS_FIELD, PRIVATE_IP_ADDRESSES_FIELD, SOURCE_DEST_CHECK_FIELD, STATUS_FIELD, SUBNET_ID_FIELD, VPC_ID_FIELD, INTERFACE_TYPE_FIELD, IPV4_PREFIXES_FIELD, IPV6_PREFIXES_FIELD));
    private static final long serialVersionUID = 1L;
    private final InstanceNetworkInterfaceAssociation association;
    private final InstanceNetworkInterfaceAttachment attachment;
    private final String description;
    private final List<GroupIdentifier> groups;
    private final List<InstanceIpv6Address> ipv6Addresses;
    private final String macAddress;
    private final String networkInterfaceId;
    private final String ownerId;
    private final String privateDnsName;
    private final String privateIpAddress;
    private final List<InstancePrivateIpAddress> privateIpAddresses;
    private final Boolean sourceDestCheck;
    private final String status;
    private final String subnetId;
    private final String vpcId;
    private final String interfaceType;
    private final List<InstanceIpv4Prefix> ipv4Prefixes;
    private final List<InstanceIpv6Prefix> ipv6Prefixes;

    private InstanceNetworkInterface(BuilderImpl builder) {
        this.association = builder.association;
        this.attachment = builder.attachment;
        this.description = builder.description;
        this.groups = builder.groups;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.macAddress = builder.macAddress;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.ownerId = builder.ownerId;
        this.privateDnsName = builder.privateDnsName;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.status = builder.status;
        this.subnetId = builder.subnetId;
        this.vpcId = builder.vpcId;
        this.interfaceType = builder.interfaceType;
        this.ipv4Prefixes = builder.ipv4Prefixes;
        this.ipv6Prefixes = builder.ipv6Prefixes;
    }

    public final InstanceNetworkInterfaceAssociation association() {
        return this.association;
    }

    public final InstanceNetworkInterfaceAttachment attachment() {
        return this.attachment;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasGroups() {
        return this.groups != null && !(this.groups instanceof SdkAutoConstructList);
    }

    public final List<GroupIdentifier> groups() {
        return this.groups;
    }

    public final boolean hasIpv6Addresses() {
        return this.ipv6Addresses != null && !(this.ipv6Addresses instanceof SdkAutoConstructList);
    }

    public final List<InstanceIpv6Address> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public final String macAddress() {
        return this.macAddress;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String privateDnsName() {
        return this.privateDnsName;
    }

    public final String privateIpAddress() {
        return this.privateIpAddress;
    }

    public final boolean hasPrivateIpAddresses() {
        return this.privateIpAddresses != null && !(this.privateIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<InstancePrivateIpAddress> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public final Boolean sourceDestCheck() {
        return this.sourceDestCheck;
    }

    public final NetworkInterfaceStatus status() {
        return NetworkInterfaceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String subnetId() {
        return this.subnetId;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String interfaceType() {
        return this.interfaceType;
    }

    public final boolean hasIpv4Prefixes() {
        return this.ipv4Prefixes != null && !(this.ipv4Prefixes instanceof SdkAutoConstructList);
    }

    public final List<InstanceIpv4Prefix> ipv4Prefixes() {
        return this.ipv4Prefixes;
    }

    public final boolean hasIpv6Prefixes() {
        return this.ipv6Prefixes != null && !(this.ipv6Prefixes instanceof SdkAutoConstructList);
    }

    public final List<InstanceIpv6Prefix> ipv6Prefixes() {
        return this.ipv6Prefixes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.association());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachment());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroups() ? this.groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Addresses() ? this.ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.macAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateDnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDestCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.interfaceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv4Prefixes() ? this.ipv4Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpv6Prefixes() ? this.ipv6Prefixes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceNetworkInterface)) {
            return false;
        }
        InstanceNetworkInterface other = (InstanceNetworkInterface)obj;
        return Objects.equals(this.association(), other.association()) && Objects.equals(this.attachment(), other.attachment()) && Objects.equals(this.description(), other.description()) && this.hasGroups() == other.hasGroups() && Objects.equals(this.groups(), other.groups()) && this.hasIpv6Addresses() == other.hasIpv6Addresses() && Objects.equals(this.ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(this.macAddress(), other.macAddress()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.privateDnsName(), other.privateDnsName()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && this.hasPrivateIpAddresses() == other.hasPrivateIpAddresses() && Objects.equals(this.privateIpAddresses(), other.privateIpAddresses()) && Objects.equals(this.sourceDestCheck(), other.sourceDestCheck()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.interfaceType(), other.interfaceType()) && this.hasIpv4Prefixes() == other.hasIpv4Prefixes() && Objects.equals(this.ipv4Prefixes(), other.ipv4Prefixes()) && this.hasIpv6Prefixes() == other.hasIpv6Prefixes() && Objects.equals(this.ipv6Prefixes(), other.ipv6Prefixes());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceNetworkInterface").add("Association", (Object)this.association()).add("Attachment", (Object)this.attachment()).add("Description", (Object)this.description()).add("Groups", this.hasGroups() ? this.groups() : null).add("Ipv6Addresses", this.hasIpv6Addresses() ? this.ipv6Addresses() : null).add("MacAddress", (Object)this.macAddress()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("OwnerId", (Object)this.ownerId()).add("PrivateDnsName", (Object)this.privateDnsName()).add("PrivateIpAddress", (Object)this.privateIpAddress()).add("PrivateIpAddresses", this.hasPrivateIpAddresses() ? this.privateIpAddresses() : null).add("SourceDestCheck", (Object)this.sourceDestCheck()).add("Status", (Object)this.statusAsString()).add("SubnetId", (Object)this.subnetId()).add("VpcId", (Object)this.vpcId()).add("InterfaceType", (Object)this.interfaceType()).add("Ipv4Prefixes", this.hasIpv4Prefixes() ? this.ipv4Prefixes() : null).add("Ipv6Prefixes", this.hasIpv6Prefixes() ? this.ipv6Prefixes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Association": {
                return Optional.ofNullable(clazz.cast(this.association()));
            }
            case "Attachment": {
                return Optional.ofNullable(clazz.cast(this.attachment()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Ipv6Addresses": {
                return Optional.ofNullable(clazz.cast(this.ipv6Addresses()));
            }
            case "MacAddress": {
                return Optional.ofNullable(clazz.cast(this.macAddress()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "PrivateDnsName": {
                return Optional.ofNullable(clazz.cast(this.privateDnsName()));
            }
            case "PrivateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddress()));
            }
            case "PrivateIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddresses()));
            }
            case "SourceDestCheck": {
                return Optional.ofNullable(clazz.cast(this.sourceDestCheck()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "InterfaceType": {
                return Optional.ofNullable(clazz.cast(this.interfaceType()));
            }
            case "Ipv4Prefixes": {
                return Optional.ofNullable(clazz.cast(this.ipv4Prefixes()));
            }
            case "Ipv6Prefixes": {
                return Optional.ofNullable(clazz.cast(this.ipv6Prefixes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceNetworkInterface, T> g) {
        return obj -> g.apply((InstanceNetworkInterface)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private InstanceNetworkInterfaceAssociation association;
        private InstanceNetworkInterfaceAttachment attachment;
        private String description;
        private List<GroupIdentifier> groups = DefaultSdkAutoConstructList.getInstance();
        private List<InstanceIpv6Address> ipv6Addresses = DefaultSdkAutoConstructList.getInstance();
        private String macAddress;
        private String networkInterfaceId;
        private String ownerId;
        private String privateDnsName;
        private String privateIpAddress;
        private List<InstancePrivateIpAddress> privateIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private Boolean sourceDestCheck;
        private String status;
        private String subnetId;
        private String vpcId;
        private String interfaceType;
        private List<InstanceIpv4Prefix> ipv4Prefixes = DefaultSdkAutoConstructList.getInstance();
        private List<InstanceIpv6Prefix> ipv6Prefixes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceNetworkInterface model) {
            this.association(model.association);
            this.attachment(model.attachment);
            this.description(model.description);
            this.groups(model.groups);
            this.ipv6Addresses(model.ipv6Addresses);
            this.macAddress(model.macAddress);
            this.networkInterfaceId(model.networkInterfaceId);
            this.ownerId(model.ownerId);
            this.privateDnsName(model.privateDnsName);
            this.privateIpAddress(model.privateIpAddress);
            this.privateIpAddresses(model.privateIpAddresses);
            this.sourceDestCheck(model.sourceDestCheck);
            this.status(model.status);
            this.subnetId(model.subnetId);
            this.vpcId(model.vpcId);
            this.interfaceType(model.interfaceType);
            this.ipv4Prefixes(model.ipv4Prefixes);
            this.ipv6Prefixes(model.ipv6Prefixes);
        }

        public final InstanceNetworkInterfaceAssociation.Builder getAssociation() {
            return this.association != null ? this.association.toBuilder() : null;
        }

        public final void setAssociation(InstanceNetworkInterfaceAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        @Override
        public final Builder association(InstanceNetworkInterfaceAssociation association) {
            this.association = association;
            return this;
        }

        public final InstanceNetworkInterfaceAttachment.Builder getAttachment() {
            return this.attachment != null ? this.attachment.toBuilder() : null;
        }

        public final void setAttachment(InstanceNetworkInterfaceAttachment.BuilderImpl attachment) {
            this.attachment = attachment != null ? attachment.build() : null;
        }

        @Override
        public final Builder attachment(InstanceNetworkInterfaceAttachment attachment) {
            this.attachment = attachment;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<GroupIdentifier.Builder> getGroups() {
            List<GroupIdentifier.Builder> result = GroupIdentifierListCopier.copyToBuilder(this.groups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroups(Collection<GroupIdentifier.BuilderImpl> groups) {
            this.groups = GroupIdentifierListCopier.copyFromBuilder(groups);
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<GroupIdentifier.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (GroupIdentifier)((GroupIdentifier.Builder)GroupIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<InstanceIpv6Address.Builder> getIpv6Addresses() {
            List<InstanceIpv6Address.Builder> result = InstanceIpv6AddressListCopier.copyToBuilder(this.ipv6Addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Addresses(Collection<InstanceIpv6Address.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copyFromBuilder(ipv6Addresses);
        }

        @Override
        public final Builder ipv6Addresses(Collection<InstanceIpv6Address> ipv6Addresses) {
            this.ipv6Addresses = InstanceIpv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(InstanceIpv6Address ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder> ... ipv6Addresses) {
            this.ipv6Addresses(Stream.of(ipv6Addresses).map(c -> (InstanceIpv6Address)((InstanceIpv6Address.Builder)InstanceIpv6Address.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMacAddress() {
            return this.macAddress;
        }

        public final void setMacAddress(String macAddress) {
            this.macAddress = macAddress;
        }

        @Override
        public final Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getPrivateDnsName() {
            return this.privateDnsName;
        }

        public final void setPrivateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
        }

        @Override
        public final Builder privateDnsName(String privateDnsName) {
            this.privateDnsName = privateDnsName;
            return this;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final List<InstancePrivateIpAddress.Builder> getPrivateIpAddresses() {
            List<InstancePrivateIpAddress.Builder> result = InstancePrivateIpAddressListCopier.copyToBuilder(this.privateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpAddresses(Collection<InstancePrivateIpAddress.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = InstancePrivateIpAddressListCopier.copyFromBuilder(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(Collection<InstancePrivateIpAddress> privateIpAddresses) {
            this.privateIpAddresses = InstancePrivateIpAddressListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(InstancePrivateIpAddress ... privateIpAddresses) {
            this.privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(Consumer<InstancePrivateIpAddress.Builder> ... privateIpAddresses) {
            this.privateIpAddresses(Stream.of(privateIpAddresses).map(c -> (InstancePrivateIpAddress)((InstancePrivateIpAddress.Builder)InstancePrivateIpAddress.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NetworkInterfaceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getInterfaceType() {
            return this.interfaceType;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        @Override
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        public final List<InstanceIpv4Prefix.Builder> getIpv4Prefixes() {
            List<InstanceIpv4Prefix.Builder> result = InstanceIpv4PrefixListCopier.copyToBuilder(this.ipv4Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv4Prefixes(Collection<InstanceIpv4Prefix.BuilderImpl> ipv4Prefixes) {
            this.ipv4Prefixes = InstanceIpv4PrefixListCopier.copyFromBuilder(ipv4Prefixes);
        }

        @Override
        public final Builder ipv4Prefixes(Collection<InstanceIpv4Prefix> ipv4Prefixes) {
            this.ipv4Prefixes = InstanceIpv4PrefixListCopier.copy(ipv4Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(InstanceIpv4Prefix ... ipv4Prefixes) {
            this.ipv4Prefixes(Arrays.asList(ipv4Prefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(Consumer<InstanceIpv4Prefix.Builder> ... ipv4Prefixes) {
            this.ipv4Prefixes(Stream.of(ipv4Prefixes).map(c -> (InstanceIpv4Prefix)((InstanceIpv4Prefix.Builder)InstanceIpv4Prefix.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<InstanceIpv6Prefix.Builder> getIpv6Prefixes() {
            List<InstanceIpv6Prefix.Builder> result = InstanceIpv6PrefixListCopier.copyToBuilder(this.ipv6Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Prefixes(Collection<InstanceIpv6Prefix.BuilderImpl> ipv6Prefixes) {
            this.ipv6Prefixes = InstanceIpv6PrefixListCopier.copyFromBuilder(ipv6Prefixes);
        }

        @Override
        public final Builder ipv6Prefixes(Collection<InstanceIpv6Prefix> ipv6Prefixes) {
            this.ipv6Prefixes = InstanceIpv6PrefixListCopier.copy(ipv6Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Prefixes(InstanceIpv6Prefix ... ipv6Prefixes) {
            this.ipv6Prefixes(Arrays.asList(ipv6Prefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Prefixes(Consumer<InstanceIpv6Prefix.Builder> ... ipv6Prefixes) {
            this.ipv6Prefixes(Stream.of(ipv6Prefixes).map(c -> (InstanceIpv6Prefix)((InstanceIpv6Prefix.Builder)InstanceIpv6Prefix.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public InstanceNetworkInterface build() {
            return new InstanceNetworkInterface(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceNetworkInterface> {
        public Builder association(InstanceNetworkInterfaceAssociation var1);

        default public Builder association(Consumer<InstanceNetworkInterfaceAssociation.Builder> association) {
            return this.association((InstanceNetworkInterfaceAssociation)((InstanceNetworkInterfaceAssociation.Builder)InstanceNetworkInterfaceAssociation.builder().applyMutation(association)).build());
        }

        public Builder attachment(InstanceNetworkInterfaceAttachment var1);

        default public Builder attachment(Consumer<InstanceNetworkInterfaceAttachment.Builder> attachment) {
            return this.attachment((InstanceNetworkInterfaceAttachment)((InstanceNetworkInterfaceAttachment.Builder)InstanceNetworkInterfaceAttachment.builder().applyMutation(attachment)).build());
        }

        public Builder description(String var1);

        public Builder groups(Collection<GroupIdentifier> var1);

        public Builder groups(GroupIdentifier ... var1);

        public Builder groups(Consumer<GroupIdentifier.Builder> ... var1);

        public Builder ipv6Addresses(Collection<InstanceIpv6Address> var1);

        public Builder ipv6Addresses(InstanceIpv6Address ... var1);

        public Builder ipv6Addresses(Consumer<InstanceIpv6Address.Builder> ... var1);

        public Builder macAddress(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder ownerId(String var1);

        public Builder privateDnsName(String var1);

        public Builder privateIpAddress(String var1);

        public Builder privateIpAddresses(Collection<InstancePrivateIpAddress> var1);

        public Builder privateIpAddresses(InstancePrivateIpAddress ... var1);

        public Builder privateIpAddresses(Consumer<InstancePrivateIpAddress.Builder> ... var1);

        public Builder sourceDestCheck(Boolean var1);

        public Builder status(String var1);

        public Builder status(NetworkInterfaceStatus var1);

        public Builder subnetId(String var1);

        public Builder vpcId(String var1);

        public Builder interfaceType(String var1);

        public Builder ipv4Prefixes(Collection<InstanceIpv4Prefix> var1);

        public Builder ipv4Prefixes(InstanceIpv4Prefix ... var1);

        public Builder ipv4Prefixes(Consumer<InstanceIpv4Prefix.Builder> ... var1);

        public Builder ipv6Prefixes(Collection<InstanceIpv6Prefix> var1);

        public Builder ipv6Prefixes(InstanceIpv6Prefix ... var1);

        public Builder ipv6Prefixes(Consumer<InstanceIpv6Prefix.Builder> ... var1);
    }
}

