/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ClientVpnEndpoint;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.EndpointSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClientVpnEndpointsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeClientVpnEndpointsResponse> {
    private static final SdkField<List<ClientVpnEndpoint>> CLIENT_VPN_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClientVpnEndpoints").getter(DescribeClientVpnEndpointsResponse.getter(DescribeClientVpnEndpointsResponse::clientVpnEndpoints)).setter(DescribeClientVpnEndpointsResponse.setter(Builder::clientVpnEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpoint").unmarshallLocationName("clientVpnEndpoint").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClientVpnEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeClientVpnEndpointsResponse.getter(DescribeClientVpnEndpointsResponse::nextToken)).setter(DescribeClientVpnEndpointsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ClientVpnEndpoint> clientVpnEndpoints;
    private final String nextToken;

    private DescribeClientVpnEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.clientVpnEndpoints = builder.clientVpnEndpoints;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasClientVpnEndpoints() {
        return this.clientVpnEndpoints != null && !(this.clientVpnEndpoints instanceof SdkAutoConstructList);
    }

    public final List<ClientVpnEndpoint> clientVpnEndpoints() {
        return this.clientVpnEndpoints;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientVpnEndpoints() ? this.clientVpnEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClientVpnEndpointsResponse)) {
            return false;
        }
        DescribeClientVpnEndpointsResponse other = (DescribeClientVpnEndpointsResponse)((Object)obj);
        return this.hasClientVpnEndpoints() == other.hasClientVpnEndpoints() && Objects.equals(this.clientVpnEndpoints(), other.clientVpnEndpoints()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClientVpnEndpointsResponse").add("ClientVpnEndpoints", this.hasClientVpnEndpoints() ? this.clientVpnEndpoints() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientVpnEndpoints": {
                return Optional.ofNullable(clazz.cast(this.clientVpnEndpoints()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClientVpnEndpointsResponse, T> g) {
        return obj -> g.apply((DescribeClientVpnEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<ClientVpnEndpoint> clientVpnEndpoints = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClientVpnEndpointsResponse model) {
            super(model);
            this.clientVpnEndpoints(model.clientVpnEndpoints);
            this.nextToken(model.nextToken);
        }

        public final List<ClientVpnEndpoint.Builder> getClientVpnEndpoints() {
            List<ClientVpnEndpoint.Builder> result = EndpointSetCopier.copyToBuilder(this.clientVpnEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClientVpnEndpoints(Collection<ClientVpnEndpoint.BuilderImpl> clientVpnEndpoints) {
            this.clientVpnEndpoints = EndpointSetCopier.copyFromBuilder(clientVpnEndpoints);
        }

        @Override
        public final Builder clientVpnEndpoints(Collection<ClientVpnEndpoint> clientVpnEndpoints) {
            this.clientVpnEndpoints = EndpointSetCopier.copy(clientVpnEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientVpnEndpoints(ClientVpnEndpoint ... clientVpnEndpoints) {
            this.clientVpnEndpoints(Arrays.asList(clientVpnEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientVpnEndpoints(Consumer<ClientVpnEndpoint.Builder> ... clientVpnEndpoints) {
            this.clientVpnEndpoints(Stream.of(clientVpnEndpoints).map(c -> (ClientVpnEndpoint)((ClientVpnEndpoint.Builder)ClientVpnEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeClientVpnEndpointsResponse build() {
            return new DescribeClientVpnEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClientVpnEndpointsResponse> {
        public Builder clientVpnEndpoints(Collection<ClientVpnEndpoint> var1);

        public Builder clientVpnEndpoints(ClientVpnEndpoint ... var1);

        public Builder clientVpnEndpoints(Consumer<ClientVpnEndpoint.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

