/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CarrierGateway;
import software.amazon.awssdk.services.ec2.model.CarrierGatewaySetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCarrierGatewaysResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeCarrierGatewaysResponse> {
    private static final SdkField<List<CarrierGateway>> CARRIER_GATEWAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CarrierGateways").getter(DescribeCarrierGatewaysResponse.getter(DescribeCarrierGatewaysResponse::carrierGateways)).setter(DescribeCarrierGatewaysResponse.setter(Builder::carrierGateways)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarrierGatewaySet").unmarshallLocationName("carrierGatewaySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CarrierGateway::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeCarrierGatewaysResponse.getter(DescribeCarrierGatewaysResponse::nextToken)).setter(DescribeCarrierGatewaysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARRIER_GATEWAYS_FIELD, NEXT_TOKEN_FIELD));
    private final List<CarrierGateway> carrierGateways;
    private final String nextToken;

    private DescribeCarrierGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.carrierGateways = builder.carrierGateways;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCarrierGateways() {
        return this.carrierGateways != null && !(this.carrierGateways instanceof SdkAutoConstructList);
    }

    public final List<CarrierGateway> carrierGateways() {
        return this.carrierGateways;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCarrierGateways() ? this.carrierGateways() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCarrierGatewaysResponse)) {
            return false;
        }
        DescribeCarrierGatewaysResponse other = (DescribeCarrierGatewaysResponse)((Object)obj);
        return this.hasCarrierGateways() == other.hasCarrierGateways() && Objects.equals(this.carrierGateways(), other.carrierGateways()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCarrierGatewaysResponse").add("CarrierGateways", this.hasCarrierGateways() ? this.carrierGateways() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CarrierGateways": {
                return Optional.ofNullable(clazz.cast(this.carrierGateways()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCarrierGatewaysResponse, T> g) {
        return obj -> g.apply((DescribeCarrierGatewaysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<CarrierGateway> carrierGateways = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCarrierGatewaysResponse model) {
            super(model);
            this.carrierGateways(model.carrierGateways);
            this.nextToken(model.nextToken);
        }

        public final List<CarrierGateway.Builder> getCarrierGateways() {
            List<CarrierGateway.Builder> result = CarrierGatewaySetCopier.copyToBuilder(this.carrierGateways);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCarrierGateways(Collection<CarrierGateway.BuilderImpl> carrierGateways) {
            this.carrierGateways = CarrierGatewaySetCopier.copyFromBuilder(carrierGateways);
        }

        @Override
        public final Builder carrierGateways(Collection<CarrierGateway> carrierGateways) {
            this.carrierGateways = CarrierGatewaySetCopier.copy(carrierGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder carrierGateways(CarrierGateway ... carrierGateways) {
            this.carrierGateways(Arrays.asList(carrierGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder carrierGateways(Consumer<CarrierGateway.Builder> ... carrierGateways) {
            this.carrierGateways(Stream.of(carrierGateways).map(c -> (CarrierGateway)((CarrierGateway.Builder)CarrierGateway.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeCarrierGatewaysResponse build() {
            return new DescribeCarrierGatewaysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCarrierGatewaysResponse> {
        public Builder carrierGateways(Collection<CarrierGateway> var1);

        public Builder carrierGateways(CarrierGateway ... var1);

        public Builder carrierGateways(Consumer<CarrierGateway.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

