"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "ALLOWED_FILE_EXTENSIONS", {
  enumerable: true,
  get: function () {
    return _shared.ALLOWED_FILE_EXTENSIONS;
  }
});
exports.MAPS_APP_ICON = exports.MAPBOX_GL_DRAW_MODES = exports.MAPBOX_GL_DRAW_CREATE_LISTENER = exports.LAYER_VISIBILITY = exports.LAYER_PANEL_SHOW_LAYER_ICON = exports.LAYER_PANEL_HIDE_LAYER_ICON = exports.LAYER_ICON_TYPE_MAP = exports.FILTER_DRAW_MODE = exports.FALLBACK_LANGUAGE = exports.DRAW_FILTER_SPATIAL_RELATIONS = exports.DRAW_FILTER_SHAPE_TITLE = exports.DRAW_FILTER_RECTANGLE_DEFAULT_LABEL = exports.DRAW_FILTER_RECTANGLE = exports.DRAW_FILTER_POLYGON_DEFAULT_LABEL = exports.DRAW_FILTER_POLYGON = exports.DRAW_FILTER_CANCEL = exports.DOCUMENTS_SMALL_LABEL_BORDER_WIDTH = exports.DOCUMENTS_NONE_LABEL_BORDER_WIDTH = exports.DOCUMENTS_MIN_MARKER_SIZE = exports.DOCUMENTS_MIN_MARKER_BORDER_THICKNESS = exports.DOCUMENTS_MIN_LABEL_SIZE = exports.DOCUMENTS_MEDIUM_LABEL_BORDER_WIDTH = exports.DOCUMENTS_MAX_MARKER_SIZE = exports.DOCUMENTS_MAX_MARKER_BORDER_THICKNESS = exports.DOCUMENTS_MAX_LABEL_SIZE = exports.DOCUMENTS_LARGE_LABEL_BORDER_WIDTH = exports.DOCUMENTS_LABEL_TEXT_TYPE = exports.DOCUMENTS_DEFAULT_TOOLTIPS = exports.DOCUMENTS_DEFAULT_SHOW_TOOLTIPS = exports.DOCUMENTS_DEFAULT_REQUEST_NUMBER = exports.DOCUMENTS_DEFAULT_MARKER_SIZE = exports.DOCUMENTS_DEFAULT_MARKER_BORDER_THICKNESS = exports.DOCUMENTS_DEFAULT_LABEL_TEXT_TYPE = exports.DOCUMENTS_DEFAULT_LABEL_SIZE = exports.DOCUMENTS_DEFAULT_LABEL_ENABLES = exports.DOCUMENTS_DEFAULT_LABEL_COLOR = exports.DOCUMENTS_DEFAULT_LABEL_BORDER_WIDTH = exports.DOCUMENTS_DEFAULT_LABEL_BORDER_COLOR = exports.DOCUMENTS_DEFAULT_DISPLAY_TOOLTIPS_ON_HOVER = exports.DOCUMENTS_DEFAULT_APPLY_GLOBAL_FILTERS = exports.DOCUMENTS = exports.DASHBOARDS_MAPS_LAYER_TYPE = exports.DASHBOARDS_MAPS_LAYER_NAME = exports.DASHBOARDS_MAPS_LAYER_ICON = exports.DASHBOARDS_MAPS_LAYER_DESCRIPTION = exports.DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE = exports.CUSTOM_MAP = exports.APP_PATH = exports.APP_API = void 0;
Object.defineProperty(exports, "MAPS_APP_ID", {
  enumerable: true,
  get: function () {
    return _shared.MAPS_APP_ID;
  }
});
exports.MAP_SAVED_OBJECT_TYPE = exports.MAP_REFERENCE_LAYER_DEFAULT_OPACITY = exports.MAP_LAYER_DEFAULT_OPACITY_STEP = exports.MAP_LAYER_DEFAULT_NAME = exports.MAP_LAYER_DEFAULT_MIN_OPACITY = exports.MAP_LAYER_DEFAULT_MAX_OPACITY = exports.MAP_INITIAL_STATE = exports.MAP_DEFAULT_MIN_ZOOM = exports.MAP_DEFAULT_MAX_ZOOM = exports.MAP_DATA_LAYER_DEFAULT_OPACITY = exports.MAPS_VISUALIZATION_DESCRIPTION = void 0;
Object.defineProperty(exports, "MAX_FILE_PAYLOAD_SIZE", {
  enumerable: true,
  get: function () {
    return _shared.MAX_FILE_PAYLOAD_SIZE;
  }
});
Object.defineProperty(exports, "MAX_FILE_PAYLOAD_SIZE_IN_MB", {
  enumerable: true,
  get: function () {
    return _shared.MAX_FILE_PAYLOAD_SIZE_IN_MB;
  }
});
exports.PER_PAGE_REQUEST_NUMBER = exports.OSD_LANGUAGES = exports.OPENSEARCH_MAP_LAYER = exports.NEW_MAP_LAYER_DEFAULT_PREFIX = exports.MIN_LONGITUDE = exports.MAX_LONGITUDE = exports.MAX_LAYER_NAME_LIMIT = exports.MAX_LAYER_LIMIT = void 0;
Object.defineProperty(exports, "PLUGIN_ID", {
  enumerable: true,
  get: function () {
    return _shared.PLUGIN_ID;
  }
});
Object.defineProperty(exports, "PLUGIN_NAME", {
  enumerable: true,
  get: function () {
    return _shared.PLUGIN_NAME;
  }
});
exports.TOOLTIP_STATE = void 0;
Object.defineProperty(exports, "fromMBtoBytes", {
  enumerable: true,
  get: function () {
    return _util.fromMBtoBytes;
  }
});

var _util = require("./util");

var _shared = require("./constants/shared");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
const DOCUMENTS_DEFAULT_MARKER_SIZE = 5;
exports.DOCUMENTS_DEFAULT_MARKER_SIZE = DOCUMENTS_DEFAULT_MARKER_SIZE;
const DOCUMENTS_MIN_MARKER_SIZE = 0;
exports.DOCUMENTS_MIN_MARKER_SIZE = DOCUMENTS_MIN_MARKER_SIZE;
const DOCUMENTS_MAX_MARKER_SIZE = 100;
exports.DOCUMENTS_MAX_MARKER_SIZE = DOCUMENTS_MAX_MARKER_SIZE;
const DOCUMENTS_DEFAULT_MARKER_BORDER_THICKNESS = 1;
exports.DOCUMENTS_DEFAULT_MARKER_BORDER_THICKNESS = DOCUMENTS_DEFAULT_MARKER_BORDER_THICKNESS;
const DOCUMENTS_MIN_MARKER_BORDER_THICKNESS = 0;
exports.DOCUMENTS_MIN_MARKER_BORDER_THICKNESS = DOCUMENTS_MIN_MARKER_BORDER_THICKNESS;
const DOCUMENTS_MAX_MARKER_BORDER_THICKNESS = 100;
exports.DOCUMENTS_MAX_MARKER_BORDER_THICKNESS = DOCUMENTS_MAX_MARKER_BORDER_THICKNESS;
const DOCUMENTS_DEFAULT_REQUEST_NUMBER = 1000;
exports.DOCUMENTS_DEFAULT_REQUEST_NUMBER = DOCUMENTS_DEFAULT_REQUEST_NUMBER;
const DOCUMENTS_DEFAULT_SHOW_TOOLTIPS = false;
exports.DOCUMENTS_DEFAULT_SHOW_TOOLTIPS = DOCUMENTS_DEFAULT_SHOW_TOOLTIPS;
const DOCUMENTS_DEFAULT_DISPLAY_TOOLTIPS_ON_HOVER = true;
exports.DOCUMENTS_DEFAULT_DISPLAY_TOOLTIPS_ON_HOVER = DOCUMENTS_DEFAULT_DISPLAY_TOOLTIPS_ON_HOVER;
const DOCUMENTS_DEFAULT_APPLY_GLOBAL_FILTERS = true;
exports.DOCUMENTS_DEFAULT_APPLY_GLOBAL_FILTERS = DOCUMENTS_DEFAULT_APPLY_GLOBAL_FILTERS;
const DOCUMENTS_DEFAULT_TOOLTIPS = [];
exports.DOCUMENTS_DEFAULT_TOOLTIPS = DOCUMENTS_DEFAULT_TOOLTIPS;
const DOCUMENTS_DEFAULT_LABEL_ENABLES = false;
exports.DOCUMENTS_DEFAULT_LABEL_ENABLES = DOCUMENTS_DEFAULT_LABEL_ENABLES;
let DOCUMENTS_LABEL_TEXT_TYPE;
exports.DOCUMENTS_LABEL_TEXT_TYPE = DOCUMENTS_LABEL_TEXT_TYPE;

(function (DOCUMENTS_LABEL_TEXT_TYPE) {
  DOCUMENTS_LABEL_TEXT_TYPE["BY_FIELD"] = "by_field";
  DOCUMENTS_LABEL_TEXT_TYPE["FIXED"] = "fixed";
})(DOCUMENTS_LABEL_TEXT_TYPE || (exports.DOCUMENTS_LABEL_TEXT_TYPE = DOCUMENTS_LABEL_TEXT_TYPE = {}));

const DOCUMENTS_DEFAULT_LABEL_TEXT_TYPE = DOCUMENTS_LABEL_TEXT_TYPE.BY_FIELD;
exports.DOCUMENTS_DEFAULT_LABEL_TEXT_TYPE = DOCUMENTS_DEFAULT_LABEL_TEXT_TYPE;
const DOCUMENTS_DEFAULT_LABEL_SIZE = 15;
exports.DOCUMENTS_DEFAULT_LABEL_SIZE = DOCUMENTS_DEFAULT_LABEL_SIZE;
const DOCUMENTS_MIN_LABEL_SIZE = 1;
exports.DOCUMENTS_MIN_LABEL_SIZE = DOCUMENTS_MIN_LABEL_SIZE;
const DOCUMENTS_MAX_LABEL_SIZE = 100;
exports.DOCUMENTS_MAX_LABEL_SIZE = DOCUMENTS_MAX_LABEL_SIZE;
const DOCUMENTS_DEFAULT_LABEL_COLOR = '#000000';
exports.DOCUMENTS_DEFAULT_LABEL_COLOR = DOCUMENTS_DEFAULT_LABEL_COLOR;
const DOCUMENTS_DEFAULT_LABEL_BORDER_COLOR = '#FFFFFF';
exports.DOCUMENTS_DEFAULT_LABEL_BORDER_COLOR = DOCUMENTS_DEFAULT_LABEL_BORDER_COLOR;
const DOCUMENTS_DEFAULT_LABEL_BORDER_WIDTH = 20;
exports.DOCUMENTS_DEFAULT_LABEL_BORDER_WIDTH = DOCUMENTS_DEFAULT_LABEL_BORDER_WIDTH;
const DOCUMENTS_NONE_LABEL_BORDER_WIDTH = 0;
exports.DOCUMENTS_NONE_LABEL_BORDER_WIDTH = DOCUMENTS_NONE_LABEL_BORDER_WIDTH;
const DOCUMENTS_SMALL_LABEL_BORDER_WIDTH = 2;
exports.DOCUMENTS_SMALL_LABEL_BORDER_WIDTH = DOCUMENTS_SMALL_LABEL_BORDER_WIDTH;
const DOCUMENTS_MEDIUM_LABEL_BORDER_WIDTH = 5;
exports.DOCUMENTS_MEDIUM_LABEL_BORDER_WIDTH = DOCUMENTS_MEDIUM_LABEL_BORDER_WIDTH;
const DOCUMENTS_LARGE_LABEL_BORDER_WIDTH = 10;
exports.DOCUMENTS_LARGE_LABEL_BORDER_WIDTH = DOCUMENTS_LARGE_LABEL_BORDER_WIDTH;
const LAYER_PANEL_HIDE_LAYER_ICON = 'eyeClosed';
exports.LAYER_PANEL_HIDE_LAYER_ICON = LAYER_PANEL_HIDE_LAYER_ICON;
const LAYER_PANEL_SHOW_LAYER_ICON = 'eye';
exports.LAYER_PANEL_SHOW_LAYER_ICON = LAYER_PANEL_SHOW_LAYER_ICON;
const MAP_DATA_LAYER_DEFAULT_OPACITY = 70;
exports.MAP_DATA_LAYER_DEFAULT_OPACITY = MAP_DATA_LAYER_DEFAULT_OPACITY;
const MAP_DEFAULT_MAX_ZOOM = 22;
exports.MAP_DEFAULT_MAX_ZOOM = MAP_DEFAULT_MAX_ZOOM;
const MAP_DEFAULT_MIN_ZOOM = 0;
exports.MAP_DEFAULT_MIN_ZOOM = MAP_DEFAULT_MIN_ZOOM;
const MAP_LAYER_DEFAULT_MAX_OPACITY = 100;
exports.MAP_LAYER_DEFAULT_MAX_OPACITY = MAP_LAYER_DEFAULT_MAX_OPACITY;
const MAP_LAYER_DEFAULT_MIN_OPACITY = 0;
exports.MAP_LAYER_DEFAULT_MIN_OPACITY = MAP_LAYER_DEFAULT_MIN_OPACITY;
const MAP_LAYER_DEFAULT_NAME = 'Default map';
exports.MAP_LAYER_DEFAULT_NAME = MAP_LAYER_DEFAULT_NAME;
const MAP_LAYER_DEFAULT_OPACITY_STEP = 1;
exports.MAP_LAYER_DEFAULT_OPACITY_STEP = MAP_LAYER_DEFAULT_OPACITY_STEP;
const MAP_REFERENCE_LAYER_DEFAULT_OPACITY = 100; // Make this configurable from map settings

exports.MAP_REFERENCE_LAYER_DEFAULT_OPACITY = MAP_REFERENCE_LAYER_DEFAULT_OPACITY;
const MAX_LAYER_LIMIT = 100;
exports.MAX_LAYER_LIMIT = MAX_LAYER_LIMIT;
const MAX_LAYER_NAME_LIMIT = 35;
exports.MAX_LAYER_NAME_LIMIT = MAX_LAYER_NAME_LIMIT;
const MAX_LONGITUDE = 180;
exports.MAX_LONGITUDE = MAX_LONGITUDE;
const MIN_LONGITUDE = -180;
exports.MIN_LONGITUDE = MIN_LONGITUDE;
const NEW_MAP_LAYER_DEFAULT_PREFIX = 'New layer';
exports.NEW_MAP_LAYER_DEFAULT_PREFIX = NEW_MAP_LAYER_DEFAULT_PREFIX;
const MAP_SAVED_OBJECT_TYPE = 'map'; // TODO: Replace with actual app icon

exports.MAP_SAVED_OBJECT_TYPE = MAP_SAVED_OBJECT_TYPE;
const MAPS_APP_ICON = 'gisApp';
exports.MAPS_APP_ICON = MAPS_APP_ICON;
const MAPS_VISUALIZATION_DESCRIPTION = 'Create map visualization with multiple layers'; // Starting position [lng, lat] and zoom

exports.MAPS_VISUALIZATION_DESCRIPTION = MAPS_VISUALIZATION_DESCRIPTION;
const MAP_INITIAL_STATE = {
  lng: 0,
  lat: 0,
  zoom: 1
};
exports.MAP_INITIAL_STATE = MAP_INITIAL_STATE;
const APP_PATH = {
  LANDING_PAGE_PATH: '/',
  CREATE_MAP: '/create',
  EDIT_MAP: '/:id',
  STATS: '/stats'
};
exports.APP_PATH = APP_PATH;
const APP_API = '/api/maps-dashboards';
exports.APP_API = APP_API;
let DASHBOARDS_MAPS_LAYER_NAME;
exports.DASHBOARDS_MAPS_LAYER_NAME = DASHBOARDS_MAPS_LAYER_NAME;

(function (DASHBOARDS_MAPS_LAYER_NAME) {
  DASHBOARDS_MAPS_LAYER_NAME["OPENSEARCH_MAP"] = "OpenSearch map";
  DASHBOARDS_MAPS_LAYER_NAME["DOCUMENTS"] = "Documents";
  DASHBOARDS_MAPS_LAYER_NAME["CUSTOM_MAP"] = "Custom map";
})(DASHBOARDS_MAPS_LAYER_NAME || (exports.DASHBOARDS_MAPS_LAYER_NAME = DASHBOARDS_MAPS_LAYER_NAME = {}));

let DASHBOARDS_MAPS_LAYER_TYPE;
exports.DASHBOARDS_MAPS_LAYER_TYPE = DASHBOARDS_MAPS_LAYER_TYPE;

(function (DASHBOARDS_MAPS_LAYER_TYPE) {
  DASHBOARDS_MAPS_LAYER_TYPE["OPENSEARCH_MAP"] = "opensearch_vector_tile_map";
  DASHBOARDS_MAPS_LAYER_TYPE["DOCUMENTS"] = "documents";
  DASHBOARDS_MAPS_LAYER_TYPE["CUSTOM_MAP"] = "custom_map";
})(DASHBOARDS_MAPS_LAYER_TYPE || (exports.DASHBOARDS_MAPS_LAYER_TYPE = DASHBOARDS_MAPS_LAYER_TYPE = {}));

let DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE;
exports.DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE = DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE;

(function (DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE) {
  DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE["WMS"] = "wms";
  DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE["TMS"] = "tms";
})(DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE || (exports.DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE = DASHBOARDS_CUSTOM_MAPS_LAYER_TYPE = {}));

let DASHBOARDS_MAPS_LAYER_ICON;
exports.DASHBOARDS_MAPS_LAYER_ICON = DASHBOARDS_MAPS_LAYER_ICON;

(function (DASHBOARDS_MAPS_LAYER_ICON) {
  DASHBOARDS_MAPS_LAYER_ICON["OPENSEARCH_MAP"] = "globe";
  DASHBOARDS_MAPS_LAYER_ICON["DOCUMENTS"] = "document";
  DASHBOARDS_MAPS_LAYER_ICON["CUSTOM_MAP"] = "globe";
})(DASHBOARDS_MAPS_LAYER_ICON || (exports.DASHBOARDS_MAPS_LAYER_ICON = DASHBOARDS_MAPS_LAYER_ICON = {}));

let DASHBOARDS_MAPS_LAYER_DESCRIPTION;
exports.DASHBOARDS_MAPS_LAYER_DESCRIPTION = DASHBOARDS_MAPS_LAYER_DESCRIPTION;

(function (DASHBOARDS_MAPS_LAYER_DESCRIPTION) {
  DASHBOARDS_MAPS_LAYER_DESCRIPTION["OPENSEARCH_MAP"] = "Use default OpenSearch basemaps.";
  DASHBOARDS_MAPS_LAYER_DESCRIPTION["DOCUMENTS"] = "View points, lines, and polygons on the map.";
  DASHBOARDS_MAPS_LAYER_DESCRIPTION["CUSTOM_MAP"] = "Configure maps to use a custom map source.";
})(DASHBOARDS_MAPS_LAYER_DESCRIPTION || (exports.DASHBOARDS_MAPS_LAYER_DESCRIPTION = DASHBOARDS_MAPS_LAYER_DESCRIPTION = {}));

const DOCUMENTS = {
  name: DASHBOARDS_MAPS_LAYER_NAME.DOCUMENTS,
  type: DASHBOARDS_MAPS_LAYER_TYPE.DOCUMENTS,
  icon: DASHBOARDS_MAPS_LAYER_ICON.DOCUMENTS,
  description: DASHBOARDS_MAPS_LAYER_DESCRIPTION.DOCUMENTS
};
exports.DOCUMENTS = DOCUMENTS;
const OPENSEARCH_MAP_LAYER = {
  name: DASHBOARDS_MAPS_LAYER_NAME.OPENSEARCH_MAP,
  type: DASHBOARDS_MAPS_LAYER_TYPE.OPENSEARCH_MAP,
  icon: DASHBOARDS_MAPS_LAYER_ICON.OPENSEARCH_MAP,
  description: DASHBOARDS_MAPS_LAYER_DESCRIPTION.OPENSEARCH_MAP
};
exports.OPENSEARCH_MAP_LAYER = OPENSEARCH_MAP_LAYER;
const CUSTOM_MAP = {
  name: DASHBOARDS_MAPS_LAYER_NAME.CUSTOM_MAP,
  type: DASHBOARDS_MAPS_LAYER_TYPE.CUSTOM_MAP,
  icon: DASHBOARDS_MAPS_LAYER_ICON.CUSTOM_MAP,
  description: DASHBOARDS_MAPS_LAYER_DESCRIPTION.CUSTOM_MAP
};
exports.CUSTOM_MAP = CUSTOM_MAP;
const LAYER_VISIBILITY = {
  NONE: 'none',
  VISIBLE: 'visible'
};
exports.LAYER_VISIBILITY = LAYER_VISIBILITY;
const LAYER_ICON_TYPE_MAP = {
  [DASHBOARDS_MAPS_LAYER_TYPE.OPENSEARCH_MAP]: 'globe',
  [DASHBOARDS_MAPS_LAYER_TYPE.DOCUMENTS]: 'document',
  [DASHBOARDS_MAPS_LAYER_TYPE.CUSTOM_MAP]: 'globe'
}; // refer https://github.com/opensearch-project/i18n-plugin/blob/main/DEVELOPER_GUIDE.md#new-locale for OSD supported languages

exports.LAYER_ICON_TYPE_MAP = LAYER_ICON_TYPE_MAP;
const OSD_LANGUAGES = ['en', 'es', 'fr', 'de', 'ja', 'ko', 'zh']; // all these codes are also supported in vector tiles map

exports.OSD_LANGUAGES = OSD_LANGUAGES;
const FALLBACK_LANGUAGE = 'en';
exports.FALLBACK_LANGUAGE = FALLBACK_LANGUAGE;
let TOOLTIP_STATE;
exports.TOOLTIP_STATE = TOOLTIP_STATE;

(function (TOOLTIP_STATE) {
  TOOLTIP_STATE["DISPLAY_FEATURES"] = "DISPLAY_FEATURES";
  TOOLTIP_STATE["FILTER_DRAW_SHAPE"] = "FILTER_DRAW_SHAPE";
})(TOOLTIP_STATE || (exports.TOOLTIP_STATE = TOOLTIP_STATE = {}));

let FILTER_DRAW_MODE;
exports.FILTER_DRAW_MODE = FILTER_DRAW_MODE;

(function (FILTER_DRAW_MODE) {
  FILTER_DRAW_MODE["NONE"] = "none";
  FILTER_DRAW_MODE["POLYGON"] = "polygon";
  FILTER_DRAW_MODE["RECTANGLE"] = "rectangle";
})(FILTER_DRAW_MODE || (exports.FILTER_DRAW_MODE = FILTER_DRAW_MODE = {}));

const MAPBOX_GL_DRAW_CREATE_LISTENER = 'draw.create';
exports.MAPBOX_GL_DRAW_CREATE_LISTENER = MAPBOX_GL_DRAW_CREATE_LISTENER;
let MAPBOX_GL_DRAW_MODES;
exports.MAPBOX_GL_DRAW_MODES = MAPBOX_GL_DRAW_MODES;

(function (MAPBOX_GL_DRAW_MODES) {
  MAPBOX_GL_DRAW_MODES["DRAW_POLYGON"] = "draw_polygon";
  MAPBOX_GL_DRAW_MODES["DRAW_RECTANGLE"] = "draw_rectangle";
  MAPBOX_GL_DRAW_MODES["SIMPLE_SELECT"] = "simple_select";
})(MAPBOX_GL_DRAW_MODES || (exports.MAPBOX_GL_DRAW_MODES = MAPBOX_GL_DRAW_MODES = {}));

const DRAW_FILTER_SHAPE_TITLE = 'DRAW SHAPE';
exports.DRAW_FILTER_SHAPE_TITLE = DRAW_FILTER_SHAPE_TITLE;
const DRAW_FILTER_POLYGON_DEFAULT_LABEL = 'polygon';
exports.DRAW_FILTER_POLYGON_DEFAULT_LABEL = DRAW_FILTER_POLYGON_DEFAULT_LABEL;
const DRAW_FILTER_RECTANGLE_DEFAULT_LABEL = 'rectangle';
exports.DRAW_FILTER_RECTANGLE_DEFAULT_LABEL = DRAW_FILTER_RECTANGLE_DEFAULT_LABEL;
const DRAW_FILTER_POLYGON = 'Draw Polygon';
exports.DRAW_FILTER_POLYGON = DRAW_FILTER_POLYGON;
const DRAW_FILTER_CANCEL = 'Cancel';
exports.DRAW_FILTER_CANCEL = DRAW_FILTER_CANCEL;
const DRAW_FILTER_RECTANGLE = 'Draw Rectangle';
exports.DRAW_FILTER_RECTANGLE = DRAW_FILTER_RECTANGLE;
const DRAW_FILTER_SPATIAL_RELATIONS = ['intersects', 'disjoint', 'within'];
exports.DRAW_FILTER_SPATIAL_RELATIONS = DRAW_FILTER_SPATIAL_RELATIONS;
const PER_PAGE_REQUEST_NUMBER = 50;
exports.PER_PAGE_REQUEST_NUMBER = PER_PAGE_REQUEST_NUMBER;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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