/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tasks;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchShardTask;
import org.opensearch.common.lifecycle.AbstractLifecycleComponent;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.tasks.CancellableTask;
import org.opensearch.tasks.SearchShardTaskCancellationStats;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskCancellationMonitoringSettings;
import org.opensearch.tasks.TaskCancellationStats;
import org.opensearch.tasks.TaskManager;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;

public class TaskCancellationMonitoringService
extends AbstractLifecycleComponent
implements TaskManager.TaskEventListeners {
    private static final Logger logger = LogManager.getLogger(TaskCancellationMonitoringService.class);
    private static final List<Class<? extends CancellableTask>> TASKS_TO_TRACK = Arrays.asList(SearchShardTask.class);
    private volatile Scheduler.Cancellable scheduledFuture;
    private final ThreadPool threadPool;
    private final TaskManager taskManager;
    private final Map<Long, Boolean> cancelledTaskTracker;
    private final Map<Class<? extends CancellableTask>, TaskCancellationStatsHolder> cancellationStatsHolder;
    private final TaskCancellationMonitoringSettings taskCancellationMonitoringSettings;

    public TaskCancellationMonitoringService(ThreadPool threadPool, TaskManager taskManager, TaskCancellationMonitoringSettings taskCancellationMonitoringSettings) {
        this.threadPool = threadPool;
        this.taskManager = taskManager;
        this.taskCancellationMonitoringSettings = taskCancellationMonitoringSettings;
        this.cancelledTaskTracker = new ConcurrentHashMap<Long, Boolean>();
        this.cancellationStatsHolder = TASKS_TO_TRACK.stream().collect(Collectors.toConcurrentMap(task -> task, task -> new TaskCancellationStatsHolder()));
        taskManager.addTaskEventListeners(this);
    }

    void doRun() {
        if (!this.taskCancellationMonitoringSettings.isEnabled() || this.cancelledTaskTracker.isEmpty()) {
            return;
        }
        Map<Class<? extends CancellableTask>, List<CancellableTask>> taskCancellationListByType = this.getCurrentRunningTasksPostCancellation();
        taskCancellationListByType.forEach((key, value) -> {
            long uniqueTasksRunningCount = value.stream().filter(task -> {
                if (this.cancelledTaskTracker.containsKey(task.getId()) && !this.cancelledTaskTracker.get(task.getId()).booleanValue()) {
                    this.cancelledTaskTracker.put(task.getId(), true);
                    return true;
                }
                return false;
            }).count();
            this.cancellationStatsHolder.get((Object)key).totalLongRunningCancelledTaskCount.inc(uniqueTasksRunningCount);
        });
    }

    protected void doStart() {
        this.scheduledFuture = this.threadPool.scheduleWithFixedDelay(() -> {
            try {
                this.doRun();
            }
            catch (Exception e) {
                logger.debug("Exception occurred in Task monitoring service", (Throwable)e);
            }
        }, this.taskCancellationMonitoringSettings.getInterval(), "generic");
    }

    protected void doStop() {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel();
        }
    }

    protected void doClose() throws IOException {
    }

    protected Map<Long, Boolean> getCancelledTaskTracker() {
        return this.cancelledTaskTracker;
    }

    @Override
    public void onTaskCompleted(Task task) {
        if (!TASKS_TO_TRACK.contains(task.getClass())) {
            return;
        }
        this.cancelledTaskTracker.entrySet().removeIf(entry -> ((Long)entry.getKey()).longValue() == task.getId());
    }

    @Override
    public void onTaskCancelled(CancellableTask task) {
        if (!TASKS_TO_TRACK.contains(task.getClass())) {
            return;
        }
        this.cancelledTaskTracker.putIfAbsent(task.getId(), false);
    }

    public TaskCancellationStats stats() {
        Map<Class<? extends CancellableTask>, List<CancellableTask>> currentRunningCancelledTasks = this.getCurrentRunningTasksPostCancellation();
        return new TaskCancellationStats(new SearchShardTaskCancellationStats(Optional.of(currentRunningCancelledTasks).map(mapper -> (List)mapper.get(SearchShardTask.class)).map(List::size).orElse(0).intValue(), this.cancellationStatsHolder.get(SearchShardTask.class).totalLongRunningCancelledTaskCount.count()));
    }

    private Map<Class<? extends CancellableTask>, List<CancellableTask>> getCurrentRunningTasksPostCancellation() {
        long currentTimeInNanos = System.nanoTime();
        return this.taskManager.getCancellableTasks().values().stream().filter(task -> TASKS_TO_TRACK.contains(task.getClass())).filter(CancellableTask::isCancelled).filter(task -> {
            long runningTimeSinceCancellationSeconds = TimeUnit.NANOSECONDS.toSeconds(currentTimeInNanos - task.getCancellationStartTimeNanos());
            return runningTimeSinceCancellationSeconds >= this.taskCancellationMonitoringSettings.getDuration().getSeconds();
        }).collect(Collectors.groupingBy(Object::getClass, Collectors.toList()));
    }

    public static class TaskCancellationStatsHolder {
        CounterMetric totalLongRunningCancelledTaskCount = new CounterMetric();
    }
}

