/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.util.CollectionUtils;

public enum Operator implements Writeable
{
    OR,
    AND;


    public BooleanClause.Occur toBooleanClauseOccur() {
        switch (this) {
            case OR: {
                return BooleanClause.Occur.SHOULD;
            }
            case AND: {
                return BooleanClause.Occur.MUST;
            }
        }
        throw Operator.newOperatorException(this.toString());
    }

    public QueryParser.Operator toQueryParserOperator() {
        switch (this) {
            case OR: {
                return QueryParser.Operator.OR;
            }
            case AND: {
                return QueryParser.Operator.AND;
            }
        }
        throw Operator.newOperatorException(this.toString());
    }

    public static Operator readFromStream(StreamInput in) throws IOException {
        return (Operator)in.readEnum(Operator.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum((Enum)this);
    }

    public static Operator fromString(String op) {
        return Operator.valueOf(op.toUpperCase(Locale.ROOT));
    }

    private static IllegalArgumentException newOperatorException(String op) {
        return new IllegalArgumentException("operator needs to be either " + CollectionUtils.arrayAsArrayList((Object[])Operator.values()) + ", but not [" + op + "]");
    }
}

