/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation;

import java.util.HashMap;
import java.util.Map;
import org.opensearch.cluster.routing.allocation.Constraint;
import org.opensearch.cluster.routing.allocation.ConstraintTypes;
import org.opensearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.opensearch.cluster.routing.allocation.allocator.ShardsBalancer;

public class RebalanceConstraints {
    private Map<String, Constraint> constraints = new HashMap<String, Constraint>();

    public RebalanceConstraints() {
        this.constraints.putIfAbsent("index.primary.shard.balance.constraint", new Constraint(ConstraintTypes.isPerIndexPrimaryShardsPerNodeBreached()));
    }

    public void updateRebalanceConstraint(String constraint, boolean enable) {
        this.constraints.get(constraint).setEnable(enable);
    }

    public long weight(ShardsBalancer balancer, BalancedShardsAllocator.ModelNode node, String index) {
        Constraint.ConstraintParams params = new Constraint.ConstraintParams(balancer, node, index);
        return params.weight(this.constraints);
    }
}

