/*
 * Decompiled with CFR 0.152.
 */
package org.octave;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.text.DecimalFormat;
import java.util.Arrays;

public class Matrix {
    private int[] dims;
    private Buffer data;
    private Object cache = null;

    public Matrix() {
        this(new double[0], new int[]{0, 0});
    }

    public Matrix(double[] dArray) {
        this(dArray, new int[]{1, dArray.length});
    }

    public Matrix(double[][] dArray) {
        int n = dArray.length;
        int n2 = n > 0 ? dArray[0].length : 0;
        int n3 = 0;
        double[] dArray2 = new double[n * n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                dArray2[n3++] = dArray[j][i];
            }
        }
        this.data = DoubleBuffer.wrap(dArray2);
        this.dims = new int[]{n, n2};
        this.cache = dArray;
    }

    public Matrix(double[][][] dArray) {
        int n = dArray.length;
        int n2 = n > 0 ? dArray[0].length : 0;
        int n3 = n2 > 0 ? dArray[0][0].length : 0;
        int n4 = 0;
        double[] dArray2 = new double[n * n2 * n3];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                for (int k = 0; k < n; ++k) {
                    dArray2[n4++] = dArray[k][j][i];
                }
            }
        }
        this.data = DoubleBuffer.wrap(dArray2);
        this.dims = new int[]{n, n2, n3};
        this.cache = dArray;
    }

    public Matrix(double[] dArray, int[] nArray) {
        this.dims = nArray;
        this.data = DoubleBuffer.wrap(dArray);
    }

    public Matrix(byte[] byArray, int[] nArray) {
        this.dims = nArray;
        this.data = ByteBuffer.wrap(byArray);
    }

    public Matrix(int[] nArray, int[] nArray2) {
        this.dims = nArray2;
        this.data = IntBuffer.wrap(nArray);
    }

    public double[] toDouble() {
        if (this.data instanceof DoubleBuffer) {
            return ((DoubleBuffer)this.data).array();
        }
        throw new ClassCastException("matrix is not of type 'double'");
    }

    public byte[] toByte() {
        if (this.data instanceof ByteBuffer) {
            return ((ByteBuffer)this.data).array();
        }
        throw new ClassCastException("matrix is not of type 'byte'");
    }

    public int[] toInt() {
        if (this.data instanceof IntBuffer) {
            return ((IntBuffer)this.data).array();
        }
        throw new ClassCastException("matrix is not of type 'integer'");
    }

    public int getNDims() {
        return this.dims == null ? 0 : this.dims.length;
    }

    public int getDim(int n) {
        return this.dims == null || n < 0 || n >= this.dims.length ? -1 : this.dims[n];
    }

    public int[] getDims() {
        return this.dims;
    }

    public String getClassName() {
        if (this.data instanceof DoubleBuffer) {
            return "double";
        }
        if (this.data instanceof IntBuffer) {
            return "integer";
        }
        if (this.data instanceof ByteBuffer) {
            return "byte";
        }
        return "unknown";
    }

    public String toString() {
        if (this.dims == null || this.data == null) {
            return "null";
        }
        String string = "";
        if (this.dims.length == 2 && this.dims[0] == 1 && this.dims[1] <= 5) {
            if (this.data instanceof DoubleBuffer) {
                DoubleBuffer doubleBuffer = (DoubleBuffer)this.data;
                DecimalFormat decimalFormat = new DecimalFormat("0.0000 ");
                for (int i = 0; i < doubleBuffer.capacity(); ++i) {
                    string = string + decimalFormat.format(doubleBuffer.get(i));
                }
            } else if (this.data instanceof IntBuffer) {
                IntBuffer intBuffer = (IntBuffer)this.data;
                for (int i = 0; i < intBuffer.capacity(); ++i) {
                    string = string + Integer.toString(intBuffer.get(i)) + " ";
                }
            } else if (this.data instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)this.data;
                for (int i = 0; i < byteBuffer.capacity(); ++i) {
                    string = string + Byte.toString(byteBuffer.get(i)) + " ";
                }
            }
            string = "[ " + string + "]";
        } else if (this.dims.length == 2 && this.dims[0] == 0 && this.dims[1] == 0) {
            string = "[ ]";
        } else {
            for (int i = 0; i < this.dims.length; ++i) {
                string = i == 0 ? Integer.toString(this.dims[i]) : string + " by " + Integer.toString(this.dims[i]);
            }
            string = "[ (" + string + ") array of " + this.getClassName() + " ]";
        }
        return string;
    }

    public static Object ident(Object object) {
        System.out.println(object);
        return object;
    }

    public boolean equals(Object object) {
        if (object instanceof Matrix) {
            Matrix matrix = (Matrix)object;
            if (!Arrays.equals(this.dims, matrix.dims)) {
                return false;
            }
            return this.data.equals(matrix.data);
        }
        return false;
    }

    public boolean isEmpty() {
        return this.data == null || this.dims == null || this.data.capacity() == 0;
    }

    public boolean isVector() {
        return this.dims.length == 1 || this.dims.length == 2 && (this.dims[0] == 1 || this.dims[1] == 1 || this.dims[0] == 0 && this.dims[1] == 0);
    }

    public int getLength() {
        return this.data.capacity();
    }

    public double[] asDoubleVector() {
        if (this.data instanceof DoubleBuffer) {
            return this.toDouble();
        }
        System.out.println("Warning: invalid conversion to double vector");
        return null;
    }

    public double[][] asDoubleMatrix() {
        if (this.cache != null) {
            try {
                return (double[][])this.cache;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this.data instanceof DoubleBuffer && this.dims.length == 2) {
            double[][] dArray = new double[this.dims[0]][this.dims[1]];
            double[] dArray2 = ((DoubleBuffer)this.data).array();
            int n = 0;
            if (dArray2.length > 0) {
                for (int i = 0; i < dArray[0].length; ++i) {
                    for (int j = 0; j < dArray.length; ++j) {
                        dArray[j][i] = dArray2[n++];
                    }
                }
            }
            this.cache = dArray;
            return dArray;
        }
        System.out.println("Warning: invalid conversion to double matrix");
        return null;
    }

    public double[][][] asDoubleMatrix3() {
        if (this.cache != null) {
            try {
                return (double[][][])this.cache;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this.data instanceof DoubleBuffer && this.dims.length == 3) {
            double[][][] dArray = new double[this.dims[0]][this.dims[1]][this.dims[2]];
            double[] dArray2 = ((DoubleBuffer)this.data).array();
            int n = 0;
            if (dArray2.length > 0) {
                for (int i = 0; i < this.dims[2]; ++i) {
                    for (int j = 0; j < this.dims[1]; ++j) {
                        for (int k = 0; k < this.dims[0]; ++k) {
                            dArray[k][j][i] = dArray2[n++];
                        }
                    }
                }
            }
            this.cache = dArray;
            return dArray;
        }
        System.out.println("Warning: invalid conversion to double array");
        return null;
    }

    public int[][] asIntMatrix() {
        if (this.cache != null) {
            try {
                return (int[][])this.cache;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (this.data instanceof IntBuffer && this.dims.length == 2) {
            int[][] nArray = new int[this.dims[0]][this.dims[1]];
            int[] nArray2 = ((IntBuffer)this.data).array();
            int n = 0;
            if (nArray2.length > 0) {
                for (int i = 0; i < nArray[0].length; ++i) {
                    for (int j = 0; j < nArray.length; ++j) {
                        nArray[j][i] = nArray2[n++];
                    }
                }
            }
            this.cache = nArray;
            return nArray;
        }
        System.out.println("Warning: invalid conversion to integer matrix");
        return null;
    }

    public double minValue() {
        double d = Double.POSITIVE_INFINITY;
        if (this.data instanceof DoubleBuffer) {
            double[] dArray = ((DoubleBuffer)this.data).array();
            for (int i = 0; i < dArray.length; ++i) {
                if (!(dArray[i] < d)) continue;
                d = dArray[i];
            }
        } else if (this.data instanceof ByteBuffer) {
            byte[] byArray = ((ByteBuffer)this.data).array();
            for (int i = 0; i < byArray.length; ++i) {
                if (!((double)byArray[i] < d)) continue;
                d = byArray[i];
            }
        } else {
            System.out.println("Warning: cannot compute min value for array of type '" + this.getClassName() + "'");
        }
        return d;
    }

    public double maxValue() {
        double d = Double.NEGATIVE_INFINITY;
        if (this.data instanceof DoubleBuffer) {
            double[] dArray = ((DoubleBuffer)this.data).array();
            for (int i = 0; i < dArray.length; ++i) {
                if (!(dArray[i] > d)) continue;
                d = dArray[i];
            }
        } else if (this.data instanceof ByteBuffer) {
            byte[] byArray = ((ByteBuffer)this.data).array();
            for (int i = 0; i < byArray.length; ++i) {
                if (!((double)byArray[i] > d)) continue;
                d = byArray[i];
            }
        } else {
            System.out.println("Warning: cannot compute max value for array of type '" + this.getClassName() + "'");
        }
        return d;
    }
}

