/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.representations;

import java.util.ArrayList;
import java.util.List;
import org.jruby.ir.operands.Label;
import org.jruby.ir.representations.BasicBlock;

class ExceptionRegion {
    private final Label firstRescueBlockLabel;
    private final List<BasicBlock> exclusiveBBs;
    private final List<ExceptionRegion> nestedRegions;
    private final BasicBlock startBB;
    private BasicBlock endBB;

    public ExceptionRegion(Label firstRescueBlockLabel, BasicBlock startBB) {
        this.firstRescueBlockLabel = firstRescueBlockLabel;
        this.startBB = startBB;
        this.exclusiveBBs = new ArrayList<BasicBlock>();
        this.nestedRegions = new ArrayList<ExceptionRegion>();
    }

    public void setEndBB(BasicBlock bb) {
        this.endBB = bb;
    }

    public BasicBlock getStartBB() {
        return this.startBB;
    }

    public BasicBlock getEndBB() {
        return this.endBB;
    }

    public List<BasicBlock> getExclusiveBBs() {
        return this.exclusiveBBs;
    }

    public void addBB(BasicBlock bb) {
        this.exclusiveBBs.add(bb);
    }

    public void addNestedRegion(ExceptionRegion r) {
        this.nestedRegions.add(r);
        this.exclusiveBBs.remove(r.exclusiveBBs.get(0));
    }

    public Label getFirstRescueBlockLabel() {
        return this.firstRescueBlockLabel;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("--- Exception Region ---");
        buf.append("\n");
        buf.append("Exclusive BBs\n");
        for (BasicBlock b2 : this.exclusiveBBs) {
            buf.append("\t");
            buf.append(b2);
            buf.append("\n");
        }
        buf.append("End: ");
        buf.append(this.endBB.getLabel());
        buf.append("\n");
        buf.append("Rescuer: ");
        buf.append(this.firstRescueBlockLabel);
        buf.append("\n");
        for (ExceptionRegion er : this.nestedRegions) {
            buf.append(er.toString());
        }
        return buf.toString();
    }
}

