/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.simple;

import org.jruby.RubyHash;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.ArgumentsCompiler;
import org.jruby.ir.targets.ClassData;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.JVM;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class NormalArgumentsCompiler
implements ArgumentsCompiler {
    private final IRBytecodeAdapter compiler;

    public NormalArgumentsCompiler(IRBytecodeAdapter compiler) {
        this.compiler = compiler;
    }

    @Override
    public void kwargsHash(int length2) {
        if (length2 > 125) {
            throw new NotCompilableException("kwargs hash has more than 125 pairs");
        }
        String incomingSig = CodegenUtils.sig(JVM.OBJECT, CodegenUtils.params(ThreadContext.class, RubyHash.class, IRubyObject.class, length2 * 2));
        String methodName = "kwargsHash:" + length2;
        ClassData classData = this.compiler.getClassData();
        if (!classData.kwargsHashMethodsDefined.containsKey(length2)) {
            SkinnyMethodAdapter adapter2 = new SkinnyMethodAdapter(this.compiler.adapter.getClassVisitor(), 4106, methodName, incomingSig, null, null);
            adapter2.aload(0);
            adapter2.aload(1);
            IRBytecodeAdapter.buildArrayFromLocals(adapter2, 2, length2 * 2);
            adapter2.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "dupKwargsHashAndPopulateFromArray", CodegenUtils.sig(RubyHash.class, ThreadContext.class, RubyHash.class, IRubyObject[].class));
            adapter2.areturn();
            adapter2.end();
            classData.kwargsHashMethodsDefined.put(length2, null);
        }
        this.compiler.adapter.invokestatic(classData.clsName, methodName, incomingSig);
    }
}

