/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.FilterModel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.autofilter.AutoFilterManager;
import org.openstreetmap.josm.gui.util.SortableTableModel;
import org.openstreetmap.josm.gui.widgets.OSDLabel;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class FilterTableModel
extends AbstractTableModel
implements SortableTableModel<Filter> {
    public static final int COL_ENABLED = 0;
    public static final int COL_HIDING = 1;
    public static final int COL_TEXT = 2;
    public static final int COL_INVERTED = 3;
    final FilterModel model = new FilterModel();
    final ListSelectionModel selectionModel;
    private final OSDLabel lblOSD = new OSDLabel("");

    public FilterTableModel(ListSelectionModel listSelectionModel) {
        this.selectionModel = listSelectionModel;
        this.loadPrefs();
    }

    private void updateFilters() {
        AutoFilterManager.getInstance().setCurrentAutoFilter(null);
        this.executeFilters(true);
    }

    public void executeFilters() {
        this.executeFilters(false);
    }

    public void executeFilters(Collection<? extends OsmPrimitive> primitives) {
        this.executeFilters(primitives, false);
    }

    public void executeFilters(boolean force) {
        if (AutoFilterManager.getInstance().getCurrentAutoFilter() == null && (force || this.model.hasFilters())) {
            this.model.executeFilters();
            this.updateMap();
        }
    }

    public void executeFilters(Collection<? extends OsmPrimitive> primitives, boolean force) {
        if (AutoFilterManager.getInstance().getCurrentAutoFilter() == null && (force || this.model.hasFilters())) {
            this.model.executeFilters(primitives);
            this.updateMap();
        }
    }

    private void updateMap() {
        MapFrame map = MainApplication.getMap();
        if (map != null && this.model.isChanged()) {
            map.filterDialog.updateDialogHeader();
        }
    }

    private void loadPrefs() {
        this.model.loadPrefs("filters.entries");
    }

    private void savePrefs() {
        this.model.savePrefs("filters.entries");
    }

    public void addFilter(Filter filter) {
        if (this.model.addFilter(filter)) {
            this.savePrefs();
            this.updateFilters();
            int size = this.model.getFiltersCount();
            this.fireTableRowsInserted(size - 1, size - 1);
        }
    }

    public void addFilters(Filter ... filters) {
        if (this.model.addFilters(filters)) {
            this.savePrefs();
            this.updateFilters();
            int size = this.model.getFiltersCount();
            this.fireTableRowsInserted(size - 1, size - 1);
        }
    }

    @Override
    public boolean doMove(int delta, int ... selectedRows) {
        return this.model.moveFilters(delta, selectedRows);
    }

    @Override
    public boolean move(int delta, int ... selectedRows) {
        if (!SortableTableModel.super.move(delta, selectedRows)) {
            return false;
        }
        this.savePrefs();
        this.updateFilters();
        int rowIndex = selectedRows[0];
        if (delta < 0) {
            this.fireTableRowsUpdated(rowIndex + delta, rowIndex);
        } else if (delta > 0) {
            this.fireTableRowsUpdated(rowIndex, rowIndex + delta);
        }
        return true;
    }

    public void removeFilter(int rowIndex) {
        this.removeFilters(rowIndex);
    }

    public void removeFilters(int ... rowIndexes) {
        boolean modified;
        Arrays.sort(rowIndexes);
        boolean bl = modified = !this.model.removeFilters(rowIndexes).isEmpty();
        if (modified) {
            this.savePrefs();
            this.updateFilters();
            int[][] groupedRows = Utils.groupIntegers(rowIndexes);
            for (int i = groupedRows.length - 1; i >= 0; --i) {
                int[] rows = groupedRows[i];
                this.fireTableRowsDeleted(rows[0], rows[1]);
            }
        }
    }

    @Override
    public Filter setValue(int rowIndex, Filter filter) {
        Filter result = this.model.setValue(rowIndex, filter);
        this.savePrefs();
        this.updateFilters();
        this.fireTableRowsUpdated(rowIndex, rowIndex);
        return result;
    }

    @Override
    public Filter getValue(int rowIndex) {
        return this.model.getValue(rowIndex);
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public int getRowCount() {
        return this.model.getFiltersCount();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int column) {
        String[] names = new String[]{I18n.trc("filter", "E"), I18n.trc("filter", "H"), I18n.trc("filter", "Text"), I18n.trc("filter", "I"), I18n.trc("filter", "M")};
        return names[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class[] classes = new Class[]{Boolean.class, Boolean.class, String.class, Boolean.class, String.class};
        return classes[column];
    }

    public boolean isCellEnabled(int row, int column) {
        return this.model.getValue((int)row).enable || column == 0;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column < 4 && this.isCellEnabled(row, column);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (row >= this.model.getFiltersCount()) {
            return;
        }
        Filter f = this.model.getValue(row);
        switch (column) {
            case 0: {
                f.enable = (Boolean)aValue;
                break;
            }
            case 1: {
                f.hiding = (Boolean)aValue;
                break;
            }
            case 2: {
                f.text = (String)aValue;
                break;
            }
            case 3: {
                f.inverted = (Boolean)aValue;
                break;
            }
        }
        this.setValue(row, f);
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row >= this.model.getFiltersCount()) {
            return null;
        }
        Filter f = this.model.getValue(row);
        switch (column) {
            case 0: {
                return f.enable;
            }
            case 1: {
                return f.hiding;
            }
            case 2: {
                return f.text;
            }
            case 3: {
                return f.inverted;
            }
            case 4: {
                switch (f.mode) {
                    case replace: {
                        return I18n.trc("filter", "R");
                    }
                    case add: {
                        return I18n.trc("filter", "A");
                    }
                    case remove: {
                        return I18n.trc("filter", "D");
                    }
                    case in_selection: {
                        return I18n.trc("filter", "F");
                    }
                }
                Logging.warn("Unknown filter mode: " + (Object)((Object)f.mode));
                break;
            }
        }
        return null;
    }

    public void drawOSDText(Graphics2D g) {
        this.model.drawOSDText(g, this.lblOSD, I18n.tr("<h2>Filter active</h2>", new Object[0]), I18n.tr("</p><p>Close the filter dialog to see all objects.<p></html>", new Object[0]));
    }

    public List<Filter> getFilters() {
        return this.model.getFilters();
    }

    @Override
    public void sort() {
        this.model.sort();
        this.fireTableDataChanged();
    }

    @Override
    public void reverse() {
        this.model.reverse();
        this.fireTableDataChanged();
    }
}

