/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.render;

import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.api.JmolRendererInterface;
import org.jmol.modelset.TickInfo;
import org.jmol.render.ShapeRenderer;
import org.jmol.util.Font;

public abstract class FontLineShapeRenderer
extends ShapeRenderer {
    protected static final int[] dashes = new int[]{12, 0, 0, 2, 5, 7, 10};
    protected static final int[] hDashes = new int[]{10, 7, 6, 1, 3, 4, 6, 7, 9};
    protected static final int[] ndots = new int[]{0, 3, 1000};
    protected static final int[] sixdots = new int[]{12, 3, 6, 1, 3, 5, 7, 9, 11};
    protected static final int[] fourdots = new int[]{13, 3, 5, 2, 5, 8, 11};
    protected static final int[] twodots = new int[]{12, 3, 4, 3, 9};
    protected short colixA;
    protected short colixB;
    protected boolean dotsOrDashes;
    protected int[] dashDots;
    protected boolean asLineOnly;
    protected float imageFontScaling;
    protected P3 tickA;
    protected P3 tickB;
    protected P3 tickAs;
    protected P3 tickBs;
    protected Font font3d;
    protected final P3i pt0i = new P3i();
    protected final P3i pt2i = new P3i();
    protected final P3i s1 = new P3i();
    protected final P3i s2 = new P3i();
    protected final P3 pointT = new P3();
    protected final P3 pointT2 = new P3();
    protected final P3 pointT3 = new P3();
    protected final V3 vectorT = new V3();
    protected final V3 vectorT2 = new V3();
    protected final V3 vectorT3 = new V3();
    protected TickInfo tickInfo;
    protected boolean draw000 = true;
    protected int width;
    protected byte endcap = (byte)3;
    protected P3 pt0 = new P3();
    protected P3 pt1 = new P3();

    protected int getDiameter(int z, int mad10OrPixels) {
        int diameter;
        boolean isMad10 = mad10OrPixels > 20;
        switch (this.exportType) {
            case 1: {
                diameter = isMad10 ? mad10OrPixels : (int)Math.floor(this.vwr.tm.unscaleToScreen(z, (float)(mad10OrPixels * 2) / 10.0f) * 1000.0f);
                break;
            }
            default: {
                if (isMad10) {
                    diameter = (int)this.vwr.tm.scaleToScreen(z, mad10OrPixels / 10);
                    break;
                }
                if (this.g3d.isAntialiased()) {
                    mad10OrPixels += mad10OrPixels;
                }
                diameter = mad10OrPixels;
            }
        }
        return diameter;
    }

    protected void renderLine(P3 p0, P3 p1, int diameter, boolean drawTicks) {
        if (diameter < 0) {
            this.g3d.drawDashedLineBits(8, 4, p0, p1);
        } else {
            this.g3d.fillCylinderBits(this.endcap, this.exportType == 1 ? -diameter : diameter, p0, p1);
        }
        if (!drawTicks || this.tickInfo == null) {
            return;
        }
        this.checkTickTemps();
        this.tickAs.setT(p0);
        this.tickBs.setT(p1);
        this.drawTicks(diameter, true);
    }

    protected void checkTickTemps() {
        if (this.tickA == null) {
            this.tickA = new P3();
            this.tickB = new P3();
            this.tickAs = new P3();
            this.tickBs = new P3();
        }
    }

    protected void drawTicks(int diameter, boolean withLabels) {
        String[] stringArray;
        if (Float.isNaN(this.tickInfo.first)) {
            this.tickInfo.first = 0.0f;
        }
        float f = this.tickInfo.ticks.x;
        if (!withLabels) {
            stringArray = null;
        } else if (this.tickInfo.tickLabelFormats == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "%0.2f";
        } else {
            stringArray = this.tickInfo.tickLabelFormats;
        }
        this.drawTicks2(f, 8, diameter, stringArray);
        this.drawTicks2(this.tickInfo.ticks.y, 4, diameter, null);
        this.drawTicks2(this.tickInfo.ticks.z, 2, diameter, null);
    }

    private void drawTicks2(float dx, int length, int diameter, String[] formats) {
        int i;
        boolean horizontal;
        float d;
        if (dx == 0.0f) {
            return;
        }
        if (this.g3d.isAntialiased()) {
            length *= 2;
        }
        this.vectorT2.set(this.tickBs.x, this.tickBs.y, 0.0f);
        this.vectorT.set(this.tickAs.x, this.tickAs.y, 0.0f);
        this.vectorT2.sub(this.vectorT);
        if (this.vectorT2.length() < 50.0f) {
            return;
        }
        float signFactor = this.tickInfo.signFactor;
        this.vectorT.sub2(this.tickB, this.tickA);
        float d0 = this.vectorT.length();
        if (this.tickInfo.scale != null) {
            if (Float.isNaN(this.tickInfo.scale.x)) {
                float a = this.vwr.getUnitCellInfo(0);
                if (!Float.isNaN(a)) {
                    this.vectorT.set(this.vectorT.x / a, this.vectorT.y / this.vwr.getUnitCellInfo(1), this.vectorT.z / this.vwr.getUnitCellInfo(2));
                }
            } else {
                this.vectorT.set(this.vectorT.x * this.tickInfo.scale.x, this.vectorT.y * this.tickInfo.scale.y, this.vectorT.z * this.tickInfo.scale.z);
            }
        }
        if ((d = this.vectorT.length() + 1.0E-4f * dx) < dx) {
            return;
        }
        float f = dx / d * d0 / d;
        this.vectorT.scale(f);
        float dz = (this.tickBs.z - this.tickAs.z) / (d / dx);
        d += this.tickInfo.first;
        float p = (float)((int)Math.floor(this.tickInfo.first / dx)) * dx - this.tickInfo.first;
        this.pointT.scaleAdd2(p / dx, this.vectorT, this.tickA);
        p += this.tickInfo.first;
        float z = this.tickAs.z;
        if (diameter < 0) {
            diameter = 1;
        }
        this.vectorT2.set(-this.vectorT2.y, this.vectorT2.x, 0.0f);
        this.vectorT2.scale((float)length / this.vectorT2.length());
        P3 ptRef = this.tickInfo.reference;
        if (ptRef == null) {
            this.pointT3.setT(this.vwr.getBoundBoxCenter());
            if (this.vwr.g.axesMode == 603979809) {
                this.pointT3.add3(1.0f, 1.0f, 1.0f);
            }
        } else {
            this.pointT3.setT(ptRef);
        }
        this.tm.transformPtScr(this.pointT3, this.pt2i);
        boolean centerX = horizontal = (double)Math.abs(this.vectorT2.x / this.vectorT2.y) < 0.2;
        boolean centerY = !horizontal;
        boolean rightJustify = !centerX && this.vectorT2.x < 0.0f;
        boolean drawLabel = formats != null && formats.length > 0;
        Object[] val = new Object[1];
        int n = i = this.draw000 ? 0 : -1;
        while (p < d) {
            if (p >= this.tickInfo.first) {
                this.pointT2.setT(this.pointT);
                this.tm.transformPt3f(this.pointT2, this.pointT2);
                int x = (int)Math.floor(this.pointT2.x + this.vectorT2.x);
                int y = (int)Math.floor(this.pointT2.y + this.vectorT2.y);
                this.drawLine((int)Math.floor(this.pointT2.x), (int)Math.floor(this.pointT2.y), (int)z, x, y, (int)z, diameter);
                if (drawLabel && (this.draw000 || p != 0.0f)) {
                    val[0] = Float.valueOf(p == 0.0f ? 0.0f : p * signFactor);
                    String s = PT.sprintf(formats[i % formats.length], "f", val);
                    this.drawString(x, y, (int)z, 4, rightJustify, centerX, centerY, (int)Math.floor(this.pointT2.y), s);
                }
            }
            this.pointT.add(this.vectorT);
            p += dx;
            z += dz;
            ++i;
        }
    }

    protected int drawLine(int x1, int y1, int z1, int x2, int y2, int z2, int diameter) {
        return this.drawLine2(this.g3d, x1, y1, z1, x2, y2, z2, diameter);
    }

    protected int drawLine2(JmolRendererInterface g3d, int x1, int y1, int z1, int x2, int y2, int z2, int diameter) {
        this.pt0.set(x1, y1, z1);
        this.pt1.set(x2, y2, z2);
        if (!this.dotsOrDashes) {
            if (diameter < 0) {
                g3d.drawDashedLineBits(8, 4, this.pt0, this.pt1);
                return 1;
            }
            g3d.fillCylinderBits((byte)2, diameter, this.pt0, this.pt1);
        } else if (this.dashDots != null) {
            int renderD = !this.isExport || this.mad == 1 ? this.width : (int)this.mad;
            FontLineShapeRenderer.drawDashedCylinder(g3d, x1, y1, z1, x2, y2, z2, this.dashDots, this.width, this.colixA, this.colixB, renderD, this.asLineOnly, this.s1);
        }
        return (diameter + 1) / 2;
    }

    protected void drawString(int x, int y, int z, int radius, boolean rightJustify, boolean centerX, boolean centerY, int yRef, String sVal) {
        if (sVal == null) {
            return;
        }
        int width = this.font3d.stringWidth(sVal);
        int height = this.font3d.getAscent();
        int xT = x;
        xT = rightJustify ? (xT -= radius / 2 + 2 + width) : (centerX ? (xT -= radius / 2 + 2 + width / 2) : (xT += radius / 2 + 2));
        int yT = y;
        yT = centerY ? (yT += height / 2) : (yRef == 0 || yRef < y ? (yT += height) : (yT -= radius / 2));
        int zT = z - radius - 2;
        if (zT < 1) {
            zT = 1;
        }
        this.g3d.drawString(sVal, this.font3d, xT, yT, zT, zT, (short)0);
    }

    protected static void drawDashedCylinder(JmolRendererInterface g3d, int xA, int yA, int zA, int xB, int yB, int zB, int[] array, int width, short colixA, short colixB, int renderD, boolean asLineOnly, P3i s1) {
        short colixE;
        boolean isDots;
        if (array == null || width < 0) {
            return;
        }
        float f = array[0];
        float dx = xB - xA;
        float dy = yB - yA;
        float dz = zB - zA;
        int n = 0;
        boolean isNdots = array == ndots;
        boolean bl = isDots = isNdots || array == sixdots;
        if (isDots) {
            if (s1 == null) {
                s1 = new P3i();
            }
            float d2 = (dx * dx + dy * dy) / (float)(width * width);
            if (isNdots) {
                f = (float)(Math.sqrt(d2) / 1.5);
                n = (int)f + 2;
            } else if (d2 < 8.0f) {
                array = twodots;
            } else if (d2 < 32.0f) {
                array = fourdots;
            }
        }
        int ptS = array[1];
        int ptE = array[2];
        short colixS = colixA;
        short s = colixE = ptE == 0 ? colixB : colixA;
        if (n == 0) {
            n = array.length;
        }
        int i = 0;
        for (int pt = 3; pt < n; ++pt) {
            i = isNdots ? i + 1 : array[pt];
            int xS = (int)Math.floor((float)xA + dx * (float)i / f);
            int yS = (int)Math.floor((float)yA + dy * (float)i / f);
            int zS = (int)Math.floor((float)zA + dz * (float)i / f);
            if (isDots) {
                s1.set(xS, yS, zS);
                if (pt == ptS) {
                    g3d.setC(colixA);
                } else if (pt == ptE) {
                    g3d.setC(colixB);
                }
                g3d.fillSphereI(width, s1);
                continue;
            }
            if (pt == ptS) {
                colixS = colixB;
            }
            i = array[++pt];
            if (pt == ptE) {
                colixE = colixB;
            }
            int xE = (int)Math.floor((float)xA + dx * (float)i / f);
            int yE = (int)Math.floor((float)yA + dy * (float)i / f);
            int zE = (int)Math.floor((float)zA + dz * (float)i / f);
            FontLineShapeRenderer.fillCylinder(g3d, colixS, colixE, (byte)2, xS, yS, zS, xE, yE, zE, renderD, asLineOnly);
        }
    }

    protected static void fillCylinder(JmolRendererInterface g3d, short colixA, short colixB, byte endcaps, int xA, int yA, int zA, int xB, int yB, int zB, int diameter, boolean asLineOnly) {
        if (asLineOnly) {
            g3d.drawLine(colixA, colixB, xA, yA, zA, xB, yB, zB);
        } else {
            g3d.fillCylinderXYZ(colixA, colixB, endcaps, diameter, xA, yA, zA, xB, yB, zB);
        }
    }
}

