
=pod

=head1 COPYRIGHT

# (c) 1992-2023 Intel Corporation.                                              
# Intel, the Intel logo, Intel, MegaCore, NIOS II, Quartus and TalkBack         
# words and logos are trademarks of Intel Corporation or its                    
# subsidiaries in the U.S. and/or other countries. Other marks and              
# brands may be claimed as the property of others.                              
# See Trademarks on intel.com for full list of Intel trademarks or the          
# Trademarks & Brands Names Database (if Intel)                                 
# or See www.Intel.com/legal (if Altera)                                        
# Your use of Intel Corporation's design tools, logic functions and             
# other software and tools, and its AMPP partner logic functions, and           
# any output files any of the foregoing (including device programming           
# or simulation files), and any associated documentation or information         
# are expressly subject to the terms and conditions of the Altera               
# Program License Subscription Agreement, Intel MegaCore Function               
# License Agreement, or other applicable license agreement, including,          
# without limitation, that your use is for the sole purpose of                  
# programming logic devices manufactured by Intel and sold by Intel or          
# its authorized distributors.                                                  
# Please refer to the applicable agreement for further details.                 


=head1 NAME

acl::CommonData.pm - Data to be used in the compiler that may need to be updated outside of the logic

=head1 SYNOPSIS

Stores some data, such as supported version numbers and Quartus download links, that may change more often than the logic using it.

=cut

package acl::CommonData;
use strict;
use Exporter;

our @ISA = qw(Exporter);
our @EXPORT = qw( @supported_acds_list @internal_acds $latest_released_quartus $min_supported_quartus %quartus_download_links $download_center_link );

our @supported_acds_list = ('19.2', '19.4', '20.1', '20.2', '20.3', '20.4', '21.1', '21.2', '21.3', '21.4', '22.1', '22.2', '22.3', '22.4');
our @internal_acds = ('23.1');
our $latest_released_quartus = q{22.4};
our $min_supported_quartus = q{19.2};
our %quartus_download_links = (
	'stdlin'	=> 'https://www.intel.com/content/www/us/en/software-kit/684187/intel-quartus-prime-standard-edition-design-software-version-21-1-for-linux.html',
	'stdwin'	=> 'https://www.intel.com/content/www/us/en/software-kit/684188/intel-quartus-prime-standard-edition-design-software-version-21-1-for-windows.html',
	'19.2lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/661712/intel-quartus-prime-pro-edition-design-software-version-19-2-for-linux.html',
	'19.4lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/661627/intel-quartus-prime-pro-edition-design-software-version-19-4-for-linux.html',
	'19.4win'	=> 'https://www.intel.com/content/www/us/en/software-kit/661628/intel-quartus-prime-pro-edition-design-software-version-19-4-for-windows.html',
	'20.1lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/660923/intel-quartus-prime-pro-edition-design-software-version-20-1-for-linux.html',
	'20.1win'	=> 'https://www.intel.com/content/www/us/en/software-kit/660925/intel-quartus-prime-pro-edition-design-software-version-20-1-for-windows.html',
	'20.2lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/660533/intel-quartus-prime-pro-edition-design-software-version-20-2-for-linux.html',
	'20.2win'	=> 'https://www.intel.com/content/www/us/en/software-kit/660537/intel-quartus-prime-pro-edition-design-software-version-20-2-for-windows.html',
	'20.3lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/660532/intel-quartus-prime-pro-edition-design-software-version-20-3-for-linux.html',
	'20.3win'	=> 'https://www.intel.com/content/www/us/en/software-kit/660536/intel-quartus-prime-pro-edition-design-software-version-20-3-for-windows.html',
	'20.4lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/710228/intel-quartus-prime-pro-edition-design-software-version-20-4-for-linux.html',
	'20.4win'	=> 'https://www.intel.com/content/www/us/en/software-kit/710229/intel-quartus-prime-pro-edition-design-software-version-20-4-for-windows.html',
	'21.1lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/670599/intel-quartus-prime-pro-edition-design-software-version-21-1-for-linux.html',
	'21.1win'	=> 'https://www.intel.com/content/www/us/en/software-kit/670601/intel-quartus-prime-pro-edition-design-software-version-21-1-for-windows.html',
	'21.2lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/670231/intel-quartus-prime-pro-edition-design-software-version-21-2-for-linux.html',
	'21.2win'	=> 'https://www.intel.com/content/www/us/en/software-kit/670232/intel-quartus-prime-pro-edition-design-software-version-21-2-for-windows.html',
	'21.3lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/670287/intel-quartus-prime-pro-edition-design-software-version-21-3-for-linux.html',
	'21.3win'	=> 'https://www.intel.com/content/www/us/en/software-kit/670288/intel-quartus-prime-pro-edition-design-software-version-21-3-for-windows.html',
	'21.4lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/706104/intel-quartus-prime-pro-edition-design-software-version-21-4-for-linux.html',
	'21.4win'	=> 'https://www.intel.com/content/www/us/en/software-kit/706105/intel-quartus-prime-pro-edition-design-software-version-21-4-for-windows.html',
	'22.1lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/727906/intel-quartus-prime-pro-edition-design-software-version-22-1-for-linux.html',
	'22.1win'	=> 'https://www.intel.com/content/www/us/en/software-kit/727907/intel-quartus-prime-pro-edition-design-software-version-22-1-for-windows.html',
	'22.2lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/734897/intel-quartus-prime-pro-edition-design-software-version-22-2-for-linux.html',
	'22.2win'	=> 'https://www.intel.com/content/www/us/en/software-kit/734898/intel-quartus-prime-pro-edition-design-software-version-22-2-for-windows.html',
	'22.3lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/746666/intel-quartus-prime-pro-edition-design-software-version-22-3-for-linux.html',
	'22.3win'	=> 'https://www.intel.com/content/www/us/en/software-kit/746667/intel-quartus-prime-pro-edition-design-software-version-22-3-for-windows.html',
	'22.4lin'	=> 'https://www.intel.com/content/www/us/en/software-kit/764010/intel-quartus-prime-pro-edition-design-software-version-22-4-for-linux.html',
	'22.4win'	=> 'https://www.intel.com/content/www/us/en/software-kit/764011/intel-quartus-prime-pro-edition-design-software-version-22-4-for-windows.html',
);
our $download_center_link = 'https://www.intel.com/content/www/us/en/collections/products/fpga/software/downloads.html?edition=pro&s=Newest';

1;
