#pragma once
// MM Host Macro
#define __mmhost_annotation(                                                   \
  buffer_location,                                                             \
  awidth,                                                                      \
  dwidth,                                                                      \
  latency,                                                                     \
  read_write_mode,                                                             \
  maxburst,                                                                    \
  align,                                                                       \
  waitrequest) [[clang::annotate("__UserSemINTEL__ mm_host_annotation", buffer_location, awidth,  dwidth, latency, read_write_mode, maxburst, align, waitrequest)]]

// Conduit Argument Macro for MM Host Base Address
#define __conduit_mmhost_annotation(                                      \
  buffer_location,                                                             \
  awidth, dwidth,                                                              \
  latency,                                                                     \
  read_write_mode,                                                             \
  maxburst,                                                                    \
  align,                                                                       \
  waitrequest) [[clang::annotate("__UserSemINTEL__ combined_conduit_mm_host_annotation", buffer_location, awidth, dwidth, latency, read_write_mode, maxburst, align, waitrequest)]]

// Set default parameters for non buffer location fields
#define __buffer_location_annotation(value) __mmhost_annotation(value, 41, 64, 1, 0, 1, 0, 0)

// Register Map Argument Macro for MM Host Base Address
#define __register_map_mmhost_annotation(                                      \
  buffer_location,                                                             \
  awidth, dwidth,                                                              \
  latency,                                                                     \
  read_write_mode,                                                             \
  maxburst,                                                                    \
  align,                                                                       \
  waitrequest) [[clang::annotate("__UserSemINTEL__ combined_agent_register_mm_host_annotation", buffer_location, awidth, dwidth, latency, read_write_mode, maxburst, align, waitrequest)]]

// Register Map Argument Macro
#define __register_map_annotation [[clang::annotate("__UserSemINTEL__ agent_register_annotation", 2)]]

// Conduit Argument Macro
#define __conduit_annotation [[clang::annotate("__UserSemINTEL__ conduit_annotation", 2)]]

// Kernel Control Interfaces
#define _streaming_interface_annotation              [[clang::annotate("__UserSemINTEL__ __IP_INTERFACE_STREAMING")]]
#define _register_map_interface_annotation           [[clang::annotate("__UserSemINTEL__ __IP_INTERFACE_CSR")]]
#define _pipelined_interface_annotation              [[clang::annotate("__UserSemINTEL__ __IP_PIPELINED")]]

#define _streaming_pipelined_interface_annotation    [[clang::annotate("__UserSemINTEL__ __IP_INTERFACE_STREAMING_PIPELINED")]]
#define _register_map_pipelined_interface_annotation [[clang::annotate("__UserSemINTEL__ __IP_INTERFACE_CSR_PIPELINED")]]
