/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.browser;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import tim.prune.data.DataPoint;
import tim.prune.data.DoubleRange;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;

public class MapCoords {
    private final String _latitude;
    private final String _longitude;
    private final String _latSpan;
    private final String _lonSpan;
    private static final NumberFormat FIVE_DP = NumberFormat.getNumberInstance(Locale.UK);

    static {
        if (FIVE_DP instanceof DecimalFormat) {
            ((DecimalFormat)FIVE_DP).applyPattern("0.00000");
        }
    }

    private MapCoords(double d, double d2, DoubleRange doubleRange, DoubleRange doubleRange2) {
        this._latitude = FIVE_DP.format(d);
        this._longitude = FIVE_DP.format(d2);
        this._latSpan = MapCoords.getSpan(doubleRange);
        this._lonSpan = MapCoords.getSpan(doubleRange2);
    }

    public static MapCoords from(TrackInfo trackInfo) {
        if (trackInfo == null || trackInfo.getTrack() == null || trackInfo.getTrack().getNumPoints() < 1) {
            return null;
        }
        Track track = trackInfo.getTrack();
        double d = MapCoords.getMedianValue(track.getLatRange());
        double d2 = MapCoords.getMedianValue(track.getLonRange());
        DataPoint dataPoint = trackInfo.getCurrentPoint();
        if (dataPoint != null) {
            d = dataPoint.getLatitude().getDouble();
            d2 = dataPoint.getLongitude().getDouble();
        }
        return new MapCoords(d, d2, track.getLatRange(), track.getLonRange());
    }

    public static MapCoords minValues(TrackInfo trackInfo) {
        if (trackInfo == null || trackInfo.getTrack() == null || trackInfo.getTrack().getNumPoints() < 1) {
            return null;
        }
        double d = trackInfo.getTrack().getLatRange().getMinimum();
        double d2 = trackInfo.getTrack().getLonRange().getMinimum();
        return new MapCoords(d, d2, null, null);
    }

    public static MapCoords maxValues(TrackInfo trackInfo) {
        if (trackInfo == null || trackInfo.getTrack() == null || trackInfo.getTrack().getNumPoints() < 1) {
            return null;
        }
        double d = trackInfo.getTrack().getLatRange().getMaximum();
        double d2 = trackInfo.getTrack().getLonRange().getMaximum();
        return new MapCoords(d, d2, null, null);
    }

    public static MapCoords from(DataPoint dataPoint) {
        if (dataPoint == null) {
            return null;
        }
        return new MapCoords(dataPoint.getLatitude().getDouble(), dataPoint.getLongitude().getDouble(), null, null);
    }

    public String getLatitude() {
        return this._latitude;
    }

    public String getLongitude() {
        return this._longitude;
    }

    public String getLatSpan() {
        return this._latSpan;
    }

    public String getLonSpan() {
        return this._lonSpan;
    }

    private static double getMedianValue(DoubleRange doubleRange) {
        return (doubleRange.getMaximum() + doubleRange.getMinimum()) / 2.0;
    }

    private static String getSpan(DoubleRange doubleRange) {
        return doubleRange == null ? "" : FIVE_DP.format(doubleRange.getMaximum() - doubleRange.getMinimum());
    }
}

