/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.tools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gephi.desktop.tools.PropertiesBar;
import org.gephi.desktop.tools.Toolbar;
import org.gephi.graph.api.Node;
import org.gephi.tools.api.ToolController;
import org.gephi.tools.spi.MouseClickEventListener;
import org.gephi.tools.spi.NodeClickEventListener;
import org.gephi.tools.spi.NodePressAndDraggingEventListener;
import org.gephi.tools.spi.NodePressingEventListener;
import org.gephi.tools.spi.Tool;
import org.gephi.tools.spi.ToolEventListener;
import org.gephi.tools.spi.ToolSelectionType;
import org.gephi.tools.spi.ToolUI;
import org.gephi.tools.spi.UnselectToolException;
import org.gephi.visualization.VizController;
import org.gephi.visualization.api.selection.SelectionManager;
import org.gephi.visualization.apiimpl.VizEvent;
import org.gephi.visualization.apiimpl.VizEventListener;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

public class DesktopToolController
implements ToolController {
    private final Tool[] tools = Lookup.getDefault().lookupAll(Tool.class).toArray(new Tool[0]);
    private PropertiesBar propertiesBar;
    private Tool currentTool;
    private ToolEventHandler[] currentHandlers;

    public void select(Tool tool) {
        this.unselect();
        if (tool == null) {
            return;
        }
        ArrayList<ToolEventHandler> handlers = new ArrayList<ToolEventHandler>();
        for (ToolEventListener toolListener : tool.getListeners()) {
            ToolEventHandler h;
            if (toolListener instanceof NodeClickEventListener) {
                h = new NodeClickEventHandler(toolListener);
                ((NodeClickEventHandler)h).select();
                handlers.add(h);
                continue;
            }
            if (toolListener instanceof NodePressingEventListener) {
                h = new NodePressingEventHandler(toolListener);
                ((NodePressingEventHandler)h).select();
                handlers.add(h);
                continue;
            }
            if (toolListener instanceof MouseClickEventListener) {
                h = new MouseClickEventHandler(toolListener);
                ((MouseClickEventHandler)h).select();
                handlers.add(h);
                continue;
            }
            if (toolListener instanceof NodePressAndDraggingEventListener) {
                h = new NodePressAndDraggingEventHandler(toolListener);
                ((NodePressAndDraggingEventHandler)h).select();
                handlers.add(h);
                continue;
            }
            throw new RuntimeException("The ToolEventListener " + toolListener.getClass().getSimpleName() + " cannot be recognized");
        }
        this.currentHandlers = handlers.toArray(new ToolEventHandler[0]);
        switch (tool.getSelectionType()) {
            case NONE: {
                VizController.getInstance().getSelectionManager().disableSelection();
                break;
            }
            case SELECTION: {
                VizController.getInstance().getSelectionManager().blockSelection(true);
                VizController.getInstance().getSelectionManager().setDraggingEnable(false);
                break;
            }
            case SELECTION_AND_DRAGGING: {
                VizController.getInstance().getSelectionManager().blockSelection(true);
                VizController.getInstance().getSelectionManager().setDraggingEnable(true);
            }
        }
        this.currentTool = tool;
        this.currentTool.select();
    }

    public void unselect() {
        if (this.currentTool != null) {
            for (ToolEventHandler handler : this.currentHandlers) {
                handler.unselect();
            }
            this.currentTool.unselect();
            this.currentHandlers = null;
            this.currentTool = null;
            if (this.propertiesBar != null) {
                this.propertiesBar.unselect();
            }
        }
    }

    public JComponent getToolbar() {
        HashMap<ToolUI, Tool> toolMap = new HashMap<ToolUI, Tool>();
        ArrayList<ToolUI> toolsUI = new ArrayList<ToolUI>();
        for (final Tool tool : this.tools) {
            ToolUI ui = tool.getUI();
            if (ui == null) continue;
            toolsUI.add(ui);
            toolMap.put(ui, tool);
        }
        Collections.sort(toolsUI, new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer p1 = ((ToolUI)o1).getPosition();
                Integer p2 = ((ToolUI)o2).getPosition();
                return p1.compareTo(p2);
            }
        });
        final Toolbar toolbar = new Toolbar();
        for (final ToolUI toolUI : toolsUI) {
            Tool tool;
            tool = (Tool)toolMap.get(toolUI);
            JToggleButton btn = toolUI.getIcon() != null ? new JToggleButton(toolUI.getIcon()) : new JToggleButton(ImageUtilities.loadImageIcon((String)"DesktopTools/tool.png", (boolean)false));
            btn.setFocusPainted(false);
            btn.setToolTipText(toolUI.getName() + " - " + toolUI.getDescription());
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (tool == DesktopToolController.this.currentTool) {
                        toolbar.clearSelection();
                        DesktopToolController.this.unselect();
                    } else {
                        try {
                            DesktopToolController.this.select(tool);
                            DesktopToolController.this.propertiesBar.select(toolUI.getPropertiesBar(tool));
                        }
                        catch (UnselectToolException unselectToolException) {
                            toolbar.clearSelection();
                            DesktopToolController.this.unselect();
                        }
                    }
                }
            });
            toolbar.add(btn);
        }
        VizController.getInstance().getSelectionManager().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SelectionManager selectionManager = VizController.getInstance().getSelectionManager();
                if (selectionManager.isRectangleSelection() && DesktopToolController.this.currentTool != null) {
                    toolbar.clearSelection();
                    DesktopToolController.this.unselect();
                } else if (selectionManager.isSelectionEnabled() && DesktopToolController.this.currentTool != null && DesktopToolController.this.currentTool.getSelectionType() == ToolSelectionType.NONE) {
                    toolbar.clearSelection();
                    DesktopToolController.this.unselect();
                } else if (selectionManager.isDraggingEnabled() && DesktopToolController.this.currentTool != null) {
                    toolbar.clearSelection();
                    DesktopToolController.this.unselect();
                }
            }
        });
        return toolbar;
    }

    public JComponent getPropertiesBar() {
        this.propertiesBar = new PropertiesBar();
        return this.propertiesBar;
    }

    private static class MouseClickEventHandler
    implements ToolEventHandler {
        private MouseClickEventListener toolEventListener;
        private VizEventListener currentListener;

        public MouseClickEventHandler(ToolEventListener toolListener) {
            this.toolEventListener = (MouseClickEventListener)toolListener;
        }

        @Override
        public void select() {
            this.currentListener = new VizEventListener(){

                public void handleEvent(VizEvent event) {
                    float[] data = (float[])event.getData();
                    int[] viewport = new int[]{(int)data[0], (int)data[1]};
                    float[] threed = new float[]{data[2], data[3]};
                    toolEventListener.mouseClick(viewport, threed);
                }

                public VizEvent.Type getType() {
                    return VizEvent.Type.MOUSE_LEFT_CLICK;
                }
            };
            VizController.getInstance().getVizEventManager().addListener(this.currentListener);
        }

        @Override
        public void unselect() {
            VizController.getInstance().getVizEventManager().removeListener(this.currentListener);
            this.toolEventListener = null;
            this.currentListener = null;
        }
    }

    private static class NodePressAndDraggingEventHandler
    implements ToolEventHandler {
        private NodePressAndDraggingEventListener toolEventListener;
        private VizEventListener[] currentListeners;

        public NodePressAndDraggingEventHandler(ToolEventListener toolListener) {
            this.toolEventListener = (NodePressAndDraggingEventListener)toolListener;
        }

        @Override
        public void select() {
            this.currentListeners = new VizEventListener[3];
            this.currentListeners[0] = new VizEventListener(){

                public void handleEvent(VizEvent event) {
                    toolEventListener.pressNodes((Node[])event.getData());
                }

                public VizEvent.Type getType() {
                    return VizEvent.Type.NODE_LEFT_PRESS;
                }
            };
            this.currentListeners[1] = new VizEventListener(){

                public void handleEvent(VizEvent event) {
                    float[] mouseDrag = (float[])event.getData();
                    toolEventListener.drag(mouseDrag[0], mouseDrag[1]);
                }

                public VizEvent.Type getType() {
                    return VizEvent.Type.DRAG;
                }
            };
            this.currentListeners[2] = new VizEventListener(){

                public void handleEvent(VizEvent event) {
                    toolEventListener.released();
                }

                public VizEvent.Type getType() {
                    return VizEvent.Type.MOUSE_RELEASED;
                }
            };
            VizController.getInstance().getVizEventManager().addListener(this.currentListeners);
        }

        @Override
        public void unselect() {
            VizController.getInstance().getVizEventManager().removeListener(this.currentListeners);
            this.toolEventListener = null;
            this.currentListeners = null;
        }
    }

    private static class NodePressingEventHandler
    implements ToolEventHandler {
        private NodePressingEventListener toolEventListener;
        private VizEventListener[] currentListeners;

        public NodePressingEventHandler(ToolEventListener toolListener) {
            this.toolEventListener = (NodePressingEventListener)toolListener;
        }

        @Override
        public void select() {
            this.currentListeners = new VizEventListener[2];
            this.currentListeners[0] = new VizEventListener(){

                public void handleEvent(VizEvent event) {
                    toolEventListener.pressingNodes((Node[])event.getData());
                }

                public VizEvent.Type getType() {
                    return VizEvent.Type.NODE_LEFT_PRESSING;
                }
            };
            this.currentListeners[1] = new VizEventListener(){

                public void handleEvent(VizEvent event) {
                    toolEventListener.released();
                }

                public VizEvent.Type getType() {
                    return VizEvent.Type.MOUSE_RELEASED;
                }
            };
            VizController.getInstance().getVizEventManager().addListener(this.currentListeners);
        }

        @Override
        public void unselect() {
            VizController.getInstance().getVizEventManager().removeListener(this.currentListeners);
            this.toolEventListener = null;
            this.currentListeners = null;
        }
    }

    private static class NodeClickEventHandler
    implements ToolEventHandler {
        private NodeClickEventListener toolEventListener;
        private VizEventListener currentListener;

        public NodeClickEventHandler(ToolEventListener toolListener) {
            this.toolEventListener = (NodeClickEventListener)toolListener;
        }

        @Override
        public void select() {
            this.currentListener = new VizEventListener(){

                public void handleEvent(VizEvent event) {
                    toolEventListener.clickNodes((Node[])event.getData());
                }

                public VizEvent.Type getType() {
                    return VizEvent.Type.NODE_LEFT_CLICK;
                }
            };
            VizController.getInstance().getVizEventManager().addListener(this.currentListener);
        }

        @Override
        public void unselect() {
            VizController.getInstance().getVizEventManager().removeListener(this.currentListener);
            this.currentListener = null;
            this.toolEventListener = null;
        }
    }

    private static interface ToolEventHandler {
        public void select();

        public void unselect();
    }
}

