/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.map.AncestorRemover;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.codeexplorer.map.CodeMap;
import org.freeplane.plugin.codeexplorer.map.CodeNode;

public class DependencySelection {
    private final IMapSelection selection;
    private CodeMap map;
    private Set<NodeModel> selectedNodeSet;
    private final boolean showsOutsideDependencies;

    public DependencySelection(IMapSelection selection) {
        this(selection, ResourceController.getResourceController().getBooleanProperty("code_showOutsideDependencies", true));
    }

    public DependencySelection(IMapSelection selection, boolean showsOutsideDependencies) {
        this.selection = selection;
        this.showsOutsideDependencies = showsOutsideDependencies;
    }

    public Stream<Dependency> getSelectedDependencies() {
        Set nodes = AncestorRemover.removeAncestors(this.getSelectedNodeSet());
        Stream<Dependency> allDependencies = nodes.stream().flatMap(node -> Stream.concat(this.getOutgoingDependencies((CodeNode)((Object)node)).stream(), this.getIncomingDependencies((CodeNode)((Object)node)).stream())).distinct();
        return allDependencies;
    }

    List<JavaClass> getSelectedClasses() {
        Set nodes = AncestorRemover.removeAncestors(this.getSelectedNodeSet());
        List allClasses = nodes.stream().flatMap(node -> Stream.concat(((CodeNode)((Object)node)).getOutgoingDependenciesWithKnownTargets().map(Dependency::getOriginClass), ((CodeNode)((Object)node)).getIncomingDependenciesWithKnownOrigins().map(Dependency::getTargetClass))).distinct().collect(Collectors.toCollection(ArrayList::new));
        return allClasses;
    }

    public CodeNode getVisibleNode(JavaClass javaClass) {
        CodeMap map = this.getMap();
        for (CodeNode node = map.getNodeByClass(javaClass); node != null; node = node.getParentNode()) {
            switch (this.visibility(node)) {
                case VISIBLE: {
                    return node;
                }
                case HIDDEN_BY_FILTER: {
                    return null;
                }
            }
        }
        return null;
    }

    private Set<Dependency> getOutgoingDependencies(CodeNode node) {
        Stream<Dependency> dependencies = node.getOutgoingDependenciesWithKnownTargets();
        return this.dependenciesBetweenDifferentElements(dependencies);
    }

    private Set<Dependency> getIncomingDependencies(CodeNode node) {
        Stream<Dependency> dependencies = node.getIncomingDependenciesWithKnownOrigins();
        return this.dependenciesBetweenDifferentElements(dependencies);
    }

    private Set<Dependency> dependenciesBetweenDifferentElements(Stream<Dependency> dependencies) {
        Set<Dependency> filteredDependencies = dependencies.filter(dependency -> this.connectsDifferentVisibleNodes((Dependency)dependency)).collect(Collectors.toSet());
        return filteredDependencies;
    }

    private NodeModel findSelectedAncestorOrSelf(NodeModel node) {
        while (node != null && !this.selectionContains(node)) {
            node = node.getParentNode();
        }
        return node;
    }

    NodeModel findVisibleAncestorOrSelf(NodeModel node) {
        while (node != null && !this.selection.isVisible(node)) {
            node = node.getParentNode();
        }
        return node;
    }

    private boolean selectionContains(NodeModel node) {
        return this.getSelectedNodeSet().contains(node);
    }

    private Set<NodeModel> getSelectedNodeSet() {
        if (this.selectedNodeSet == null) {
            this.selectedNodeSet = this.selection.getSelection();
        }
        return this.selectedNodeSet;
    }

    public CodeMap getMap() {
        if (this.map == null) {
            this.map = (CodeMap)this.selection.getMap();
        }
        return this.map;
    }

    private Visibility visibility(NodeModel node) {
        if (node == null) {
            return Visibility.UNKNOWN;
        }
        if (this.selection.isVisible(node)) {
            return Visibility.VISIBLE;
        }
        if (!node.isVisible(this.selection.getFilter())) {
            return Visibility.HIDDEN_BY_FILTER;
        }
        return Visibility.HIDDEN_BY_FOLDING;
    }

    private boolean connectsDifferentVisibleNodes(Dependency dependency) {
        CodeNode visibleOrigin = this.getVisibleNode(dependency.getOriginClass());
        CodeNode visibleTarget = this.getVisibleNode(dependency.getTargetClass());
        return visibleOrigin != null && visibleTarget != null && visibleOrigin != visibleTarget && this.isConnectorSelected(visibleOrigin, visibleTarget);
    }

    public boolean isConnectorSelected(CodeNode origin, CodeNode target) {
        boolean areOriginAndTargetSelected;
        boolean isTargetSelected;
        Set<NodeModel> selectedNodes = this.getSelectedNodeSet();
        boolean isOnlyOneNodeSelected = selectedNodes.size() == 1;
        NodeModel selectionRoot = this.selection.getSelectionRoot();
        if (origin == selectionRoot || target == selectionRoot) {
            return false;
        }
        if (isOnlyOneNodeSelected && this.selection.getSelected() == selectionRoot) {
            return false;
        }
        NodeModel selectedOriginAncestorOrOrigin = this.findSelectedAncestorOrSelf(origin);
        boolean isOriginSelected = selectedOriginAncestorOrOrigin != null;
        NodeModel selectedTargetAncestorOrTarget = this.findSelectedAncestorOrSelf(target);
        boolean bl = isTargetSelected = selectedTargetAncestorOrTarget != null;
        if (!isOriginSelected && !isTargetSelected) {
            return false;
        }
        if (isOnlyOneNodeSelected) {
            return true;
        }
        boolean bl2 = areOriginAndTargetSelected = isOriginSelected && isTargetSelected;
        if (this.showsOutsideDependencies) {
            return !areOriginAndTargetSelected;
        }
        if (areOriginAndTargetSelected) {
            return selectedOriginAncestorOrOrigin != selectedTargetAncestorOrTarget;
        }
        return false;
    }

    private static enum Visibility {
        VISIBLE,
        HIDDEN_BY_FILTER,
        HIDDEN_BY_FOLDING,
        UNKNOWN;

    }
}

