/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.util.collection.IListModel;
import org.freeplane.core.util.collection.SortedComboBoxModel;
import org.freeplane.core.util.collection.SortedMapVector;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.AttributeRegistryComboBoxColumnModel;
import org.freeplane.features.attribute.AttributeRegistryElement;
import org.freeplane.features.attribute.AttributeRegistryTableModel;
import org.freeplane.features.attribute.IAttributesListener;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.n3.nanoxml.XMLElement;

public class AttributeRegistry
implements IExtension {
    public static final int GLOBAL = -1;
    private AttributeController attributeController;
    private ChangeEvent attributesEvent;
    private String attributeViewType;
    private ChangeEvent changeEvent;
    protected SortedMapVector elements;
    protected boolean isAttributeLayoutChanged;
    private boolean isRestricted;
    private Set<IAttributesListener> attributeListeners = null;
    private Set<ChangeListener> changeListeners = null;
    private AttributeRegistryComboBoxColumnModel myComboBoxColumnModel = null;
    private AttributeRegistryTableModel myTableModel = null;
    private Boolean restrictionModel;
    protected int visibleElementsNumber;
    private final MapModel map;

    public static AttributeRegistry getRegistry(MapModel map) {
        AttributeRegistry registry = map.getExtension(AttributeRegistry.class);
        if (registry == null) {
            AttributeController attributeController = AttributeController.getController();
            registry = new AttributeRegistry(map, attributeController);
            map.addExtension(AttributeRegistry.class, registry);
            NodeModel rootNode = map.getRootNode();
            if (rootNode != null) {
                registry.registryAttributes(Controller.getCurrentModeController().getMapController(), rootNode);
            }
        }
        return registry;
    }

    public AttributeRegistry(MapModel map, AttributeController attributeController) {
        this.map = map;
        this.attributeListeners = new LinkedHashSet<IAttributesListener>();
        this.changeListeners = new LinkedHashSet<ChangeListener>();
        this.isAttributeLayoutChanged = false;
        this.attributeController = attributeController;
        this.visibleElementsNumber = 0;
        this.elements = new SortedMapVector();
        this.myTableModel = new AttributeRegistryTableModel(this);
        this.isRestricted = false;
        this.restrictionModel = Boolean.FALSE;
        this.attributeViewType = "extended";
    }

    public void addAttributesListener(IAttributesListener l) {
        this.attributeListeners.add(l);
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListeners.add(l);
    }

    public void applyChanges() {
        if (!this.isAttributeLayoutChanged) {
            return;
        }
        this.getAttributeController().performSetRestriction(this.map, -1, this.restrictionModel);
        for (int i = 0; i < this.elements.size(); ++i) {
            AttributeRegistryElement element = this.getElement(i);
            this.getAttributeController().performSetVisibility(this.map, i, element.getVisibilityModel());
            this.getAttributeController().performSetRestriction(this.map, i, element.getRestriction());
        }
        this.isAttributeLayoutChanged = false;
    }

    public boolean containsElement(String name) {
        return this.elements.containsKey((Comparable)((Object)name));
    }

    public void decrementVisibleElementsNumber() {
        --this.visibleElementsNumber;
    }

    public boolean exist(String attributeName, Object element) {
        int index = this.indexOf(attributeName);
        if (index == -1) {
            return false;
        }
        SortedComboBoxModel values = this.getElement(index).getValues();
        for (int i = 0; i < values.getSize(); ++i) {
            if (!element.equals(values.getElementAt(i))) continue;
            return true;
        }
        return false;
    }

    public void fireAttributeLayoutChanged() {
        this.fireStateChanged();
    }

    protected void fireAttributesChanged() {
        for (IAttributesListener l : this.attributeListeners) {
            if (this.attributesEvent == null) {
                this.attributesEvent = new ChangeEvent(this);
            }
            l.attributesChanged(this.changeEvent);
        }
    }

    public void fireStateChanged() {
        ChangeListener[] currentChangeListeners;
        for (ChangeListener l : currentChangeListeners = this.changeListeners.toArray(new ChangeListener[this.changeListeners.size()])) {
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            l.stateChanged(this.changeEvent);
        }
    }

    public AttributeController getAttributeController() {
        return this.attributeController;
    }

    public String getAttributeViewType() {
        return this.attributeViewType;
    }

    private AttributeRegistryComboBoxColumnModel getCombinedModel() {
        if (this.myComboBoxColumnModel == null) {
            this.myComboBoxColumnModel = new AttributeRegistryComboBoxColumnModel(this);
        }
        return this.myComboBoxColumnModel;
    }

    public ComboBoxModel getComboBoxModel() {
        return this.getCombinedModel();
    }

    public ComboBoxModel getDefaultComboBoxModel(Comparable<?> attrName) {
        try {
            AttributeRegistryElement elem = this.getElement(attrName);
            return elem.getValues();
        }
        catch (NoSuchElementException ex) {
            return this.getComboBoxModel();
        }
    }

    public AttributeRegistryElement getElement(Comparable<?> attrName) {
        AttributeRegistryElement elem = (AttributeRegistryElement)this.elements.getValue(attrName);
        return elem;
    }

    public AttributeRegistryElement getElement(int index) {
        return (AttributeRegistryElement)this.elements.getValue(index);
    }

    public SortedMapVector getElements() {
        return this.elements;
    }

    public Comparable<?> getKey(int index) {
        return this.elements.getKey(index);
    }

    public IListModel getListBoxModel() {
        return this.getCombinedModel();
    }

    Boolean getRestriction(int row) {
        if (row == -1) {
            return this.restrictionModel;
        }
        return this.getElement(row).getRestriction();
    }

    public AttributeRegistryTableModel getTableModel() {
        return this.myTableModel;
    }

    public IListModel getValues(int row) {
        if (row == -1) {
            return this.getListBoxModel();
        }
        return this.getElement(row).getValues();
    }

    public int getVisibleElementsNumber() {
        return this.visibleElementsNumber;
    }

    public void incrementVisibleElementsNumber() {
        ++this.visibleElementsNumber;
    }

    public int indexOf(String string) {
        return this.elements.indexOf((Comparable)((Object)string));
    }

    public boolean isRestricted() {
        return this.isRestricted;
    }

    public boolean isRestricted(String s) {
        return this.getRestriction(this.indexOf(s));
    }

    public void registry(Attribute newAttribute) {
        String name = newAttribute.getName();
        if (name.equals("")) {
            return;
        }
        Object value = newAttribute.getValue();
        try {
            AttributeRegistryElement elem = this.getElement((Comparable<?>)((Object)name));
            elem.addValue(value);
        }
        catch (NoSuchElementException ex) {
            AttributeRegistryElement attributeRegistryElement = new AttributeRegistryElement(this, name);
            attributeRegistryElement.addValue(value);
            int index = this.getElements().add((Comparable)((Object)name), attributeRegistryElement);
            this.getTableModel().fireTableRowsInserted(index, index);
        }
        this.fireAttributesChanged();
    }

    public void registry(String name) {
        AttributeRegistryElement attributeRegistryElement = new AttributeRegistryElement(this, name);
        int index = this.getElements().add((Comparable)((Object)name), attributeRegistryElement);
        this.getTableModel().fireTableRowsInserted(index, index);
    }

    private void registryAttributes(MapController mapController, NodeModel node) {
        NodeAttributeTableModel model = NodeAttributeTableModel.getModel(node);
        if (model == null) {
            return;
        }
        for (int i = 0; i < model.getRowCount(); ++i) {
            this.registry(model.getAttribute(i));
        }
        for (NodeModel child : node.getChildren()) {
            this.registryAttributes(mapController, child);
        }
    }

    void removeAtribute(Object o) {
        this.getAttributeController().performRemoveAttribute(this.map, o.toString());
    }

    public void removeAttributesListener(IAttributesListener l) {
        this.attributeListeners.remove(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    public void resetChanges() {
        if (!this.isAttributeLayoutChanged) {
            return;
        }
        this.restrictionModel = this.isRestricted;
        for (int i = 0; i < this.elements.size(); ++i) {
            AttributeRegistryElement element = this.getElement(i);
            element.setVisibilityModel(element.isVisible());
            element.setRestrictionModel(element.isRestricted());
        }
        this.isAttributeLayoutChanged = false;
    }

    public void setAttributeLayoutChanged() {
        this.isAttributeLayoutChanged = true;
    }

    public void setAttributeViewType(String attributeViewType) {
        this.attributeViewType = attributeViewType;
        this.fireStateChanged();
    }

    public void setRestricted(boolean b) {
        this.isRestricted = b;
        this.restrictionModel = this.isRestricted;
        this.fireAttributesChanged();
    }

    private void setRestricted(int row, boolean b) {
        this.getElement(row).setRestriction(b);
    }

    public void setRestricted(String s, boolean b) {
        this.setRestricted(this.indexOf(s), b);
    }

    public void setRestrictionModel(int row, Boolean value) {
        if (row == -1) {
            this.restrictionModel = value;
        } else {
            this.getElement(row).setRestrictionModel(value);
        }
        this.setAttributeLayoutChanged();
        this.myTableModel.fireRestrictionsUpdated(row);
    }

    public void setVisibilityModel(int row, Boolean visible) {
        AttributeRegistryElement element = this.getElement(row);
        if (!element.getVisibilityModel().equals(visible)) {
            element.setVisibilityModel(visible);
            this.setAttributeLayoutChanged();
            this.myTableModel.fireVisibilityUpdated(row);
        }
    }

    public int size() {
        return this.elements.size();
    }

    public void unregistry(String name) {
        int index = this.elements.indexOf((Comparable)((Object)name));
        if (this.getElement(index).isVisible()) {
            this.decrementVisibleElementsNumber();
        }
        this.elements.remove(index);
        this.getTableModel().fireTableRowsDeleted(index, index);
        this.fireAttributesChanged();
    }

    public void write(ITreeWriter writer) throws IOException {
        XMLElement attributeRegistry = new XMLElement();
        boolean toBeSaved = false;
        if (this.isRestricted()) {
            attributeRegistry.setAttribute("RESTRICTED", "true");
            toBeSaved = true;
        }
        if (!this.attributeViewType.equals("extended")) {
            attributeRegistry.setAttribute("SHOW_ATTRIBUTES", this.attributeViewType);
            toBeSaved = true;
        }
        for (int i = 0; i < this.size(); ++i) {
            AttributeRegistryElement element = this.getElement(i);
            if (!element.isRestricted() && !element.isVisible() && !element.isManual()) continue;
            XMLElement attributeData = element.save();
            attributeRegistry.addChild(attributeData);
            toBeSaved = true;
        }
        if (toBeSaved) {
            attributeRegistry.setName("attribute_registry");
            writer.addElement((Object)this, attributeRegistry);
        }
    }

    public MapModel getMap() {
        return this.map;
    }

    public void performRegistryAttributeValue(String name, String value, boolean manual) {
        this.getAttributeController().performRegistryAttributeValue(this.map, name, value, manual);
    }

    void performRemoveAttributeValue(String name, Object value) {
        this.getAttributeController().performRemoveAttributeValue(this.map, name, value);
    }

    void performReplaceAttributeValue(String name, Object oldO, Object newO) {
        this.getAttributeController().performReplaceAttributeValue(this.map, name, oldO, newO);
    }

    void performReplaceAtributeName(String oldName, String newName) {
        this.getAttributeController().performReplaceAtributeName(this.map, oldName, newName);
    }

    public void performRegistryAttribute(String name) {
        this.getAttributeController().performRegistryAttribute(this.map, name);
    }

    public void performSetRestriction(int index, boolean restricted) {
        this.getAttributeController().performSetRestriction(this.map, index, restricted);
    }
}

