/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import * as tslib_1 from "tslib";
import { ChangeDetectionStrategy } from '../change_detection/constants';
import { compileComponent as render3CompileComponent, compileDirective as render3CompileDirective } from '../render3/jit/directive';
import { compilePipe as render3CompilePipe } from '../render3/jit/pipe';
import { makeDecorator, makePropDecorator } from '../util/decorators';
import { noop } from '../util/noop';
var ɵ0 = function (dir) {
    if (dir === void 0) { dir = {}; }
    return dir;
}, ɵ1 = function (type, meta) { return SWITCH_COMPILE_DIRECTIVE(type, meta); };
/**
 * Type of the Directive metadata.
 *
 * @publicApi
 */
export var Directive = makeDecorator('Directive', ɵ0, undefined, undefined, ɵ1);
var ɵ2 = function (c) {
    if (c === void 0) { c = {}; }
    return (tslib_1.__assign({ changeDetection: ChangeDetectionStrategy.Default }, c));
}, ɵ3 = function (type, meta) { return SWITCH_COMPILE_COMPONENT(type, meta); };
/**
 * Component decorator and metadata.
 *
 * @Annotation
 * @publicApi
 */
export var Component = makeDecorator('Component', ɵ2, Directive, undefined, ɵ3);
var ɵ4 = function (p) { return (tslib_1.__assign({ pure: true }, p)); }, ɵ5 = function (type, meta) { return SWITCH_COMPILE_PIPE(type, meta); };
/**
 * @Annotation
 * @publicApi
 */
export var Pipe = makeDecorator('Pipe', ɵ4, undefined, undefined, ɵ5);
var ɵ6 = function (bindingPropertyName) { return ({ bindingPropertyName: bindingPropertyName }); };
/**
 * @Annotation
 * @publicApi
 */
export var Input = makePropDecorator('Input', ɵ6);
var ɵ7 = function (bindingPropertyName) { return ({ bindingPropertyName: bindingPropertyName }); };
/**
 * @Annotation
 * @publicApi
 */
export var Output = makePropDecorator('Output', ɵ7);
var ɵ8 = function (hostPropertyName) { return ({ hostPropertyName: hostPropertyName }); };
/**
 * @Annotation
 * @publicApi
 */
export var HostBinding = makePropDecorator('HostBinding', ɵ8);
var ɵ9 = function (eventName, args) { return ({ eventName: eventName, args: args }); };
/**
 * Decorator that binds a DOM event to a host listener and supplies configuration metadata.
 * Angular invokes the supplied handler method when the host element emits the specified event,
 * and updates the bound element with the result.
 *
 * If the handler method returns false, applies `preventDefault` on the bound element.
 *
 * @usageNotes
 *
 * The following example declares a directive
 * that attaches a click listener to a button and counts clicks.
 *
 * ```ts
 * @Directive({selector: 'button[counting]'})
 * class CountClicks {
 *   numberOfClicks = 0;
 *
 *   @HostListener('click', ['$event.target'])
 *   onClick(btn) {
 *     console.log('button', btn, 'number of clicks:', this.numberOfClicks++);
 *  }
 * }
 *
 * @Component({
 *   selector: 'app',
 *   template: '<button counting>Increment</button>',
 * })
 * class App {}
 * ```
 *
 * @Annotation
 * @publicApi
 */
export var HostListener = makePropDecorator('HostListener', ɵ9);
export var SWITCH_COMPILE_COMPONENT__POST_R3__ = render3CompileComponent;
export var SWITCH_COMPILE_DIRECTIVE__POST_R3__ = render3CompileDirective;
export var SWITCH_COMPILE_PIPE__POST_R3__ = render3CompilePipe;
var SWITCH_COMPILE_COMPONENT__PRE_R3__ = noop;
var SWITCH_COMPILE_DIRECTIVE__PRE_R3__ = noop;
var SWITCH_COMPILE_PIPE__PRE_R3__ = noop;
var SWITCH_COMPILE_COMPONENT = SWITCH_COMPILE_COMPONENT__PRE_R3__;
var SWITCH_COMPILE_DIRECTIVE = SWITCH_COMPILE_DIRECTIVE__PRE_R3__;
var SWITCH_COMPILE_PIPE = SWITCH_COMPILE_PIPE__PRE_R3__;
export { ɵ0, ɵ1, ɵ2, ɵ3, ɵ4, ɵ5, ɵ6, ɵ7, ɵ8, ɵ9 };
//# sourceMappingURL=data:application/json;base64,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