/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries.filters;

import cc.arduino.contributions.VersionComparator;
import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.LibrariesIndexer;
import java.util.List;
import java.util.function.Predicate;
import processing.app.BaseNoGui;

public class UpdatableLibraryPredicate
implements Predicate<ContributedLibrary> {
    LibrariesIndexer librariesIndexer;

    public UpdatableLibraryPredicate() {
        this.librariesIndexer = BaseNoGui.librariesIndexer;
    }

    public UpdatableLibraryPredicate(LibrariesIndexer indexer) {
        this.librariesIndexer = indexer;
    }

    @Override
    public boolean test(ContributedLibrary lib) {
        if (!lib.isLibraryInstalled()) {
            return false;
        }
        String libraryName = lib.getName();
        List libraries = this.librariesIndexer.getIndex().find(libraryName);
        ContributedLibrary latest = (ContributedLibrary)libraries.stream().reduce(VersionComparator::max).get();
        return !latest.isLibraryInstalled();
    }
}

