// This file was generated by $generator from $template

#include "$prefixSpecializations.h"
#include "anari/anari_cpp.hpp"

#include <cstdlib>
#include <cstring>

$begin_namespaces

Object<Frame>::Object(ANARIDevice d, ANARIObject handle)
    : DefaultObject(d, handle)
{}

void Object<Frame>::commit()
{
  DefaultObject::commit();

  size[0] = size[1] = 16; // some non null placeholder value
  current.size.get(ANARI_UINT32_VEC2, size);

  uint32_t elements = size[0] * size[1];

  colorType = ANARI_UNKNOWN;
  depthType = ANARI_UNKNOWN;
  if (current.color.get(ANARI_DATA_TYPE, &colorType)) {
    color.resize(elements * anari::sizeOf(colorType));
  }
  if (current.depth.get(ANARI_DATA_TYPE, &depthType)) {
    depth.resize(elements); // only FLOAT32 is valid
  }
}

void *Object<Frame>::mapFrame(const char *channel,
    uint32_t *width,
    uint32_t *height,
    ANARIDataType *pixelType)
{
  *width = size[0];
  *height = size[1];
  if (std::strncmp(channel, "channel.color", 13) == 0) {
    *pixelType = colorType;
    return color.data();
  } else if (std::strncmp(channel, "channel.depth", 13) == 0) {
    *pixelType = depthType;
    return depth.data();
  } else {
    *width = *height = 0;
    return nullptr;
  }
}

void Object<Frame>::unmapFrame(const char *channel)
{
  (void)channel;
}

void Object<Frame>::renderFrame() {}

void Object<Frame>::discardFrame() {}

int Object<Frame>::frameReady(ANARIWaitMask mask)
{
  (void)mask;
  return 1;
}

$end_namespaces
