
# This chunk of stuff was generated by App::FatPacker. To find the original
# file's code, look for the end of this BEGIN block or the string 'FATPACK'
BEGIN {
my %fatpacked;

$fatpacked{"App/RecordStream/Bio.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'APP_RECORDSTREAM_BIO';
  package App::RecordStream::Bio;use strict;use 5.010;our$VERSION='0.17';eval {require App::RecordStream::Site;App::RecordStream::Site->register_site(name=>__PACKAGE__,path=>__PACKAGE__,)};1;
APP_RECORDSTREAM_BIO

$fatpacked{"App/RecordStream/Operation/fromfasta.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'APP_RECORDSTREAM_OPERATION_FROMFASTA';
  package App::RecordStream::Operation::fromfasta;use strict;use warnings;use base qw(App::RecordStream::Operation);sub init {my$self=shift;my$args=shift;my$oneline=0;my%options=("oneline"=>\$oneline,);$self->parse_options($args,\%options);$self->{ONELINE}=$oneline}sub accept_line {my$self=shift;my$line=shift;if ($line =~ /^>\s*(.*?)\s*$/){my$name=$1;my ($id,$desc)=split /\h/,$name,2;$self->push_accumulated_record;$self->{RECORD}=App::RecordStream::Record->new(name=>$name,id=>$id,description=>$desc,_filename=>$self->get_current_filename,)}else {$self->{SEQUENCE}.= $line .($self->{ONELINE}? "" : "\n")}return 1}sub push_accumulated_record {my$self=shift;if (my$record=delete$self->{RECORD}){my$seq=delete$self->{SEQUENCE};chomp$seq if defined$seq;$record->set(sequence=>$seq);my$filename=$self->get_current_filename;$self->update_current_filename(delete$record->{_filename});$self->push_record($record);$self->update_current_filename($filename);return 1}else {return 0}}sub stream_done {my$self=shift;$self->push_accumulated_record}sub usage {my$self=shift;my$options=[['oneline','Strip any newlines from the sequence so it is one long line'],];my$args_string=$self->options_string($options);return <<USAGE}1;
  Usage: recs-fromfasta <args> [<files>]
     __FORMAT_TEXT__
     Each sequence from the FASTA input files (or stdin) produces an output
     record with the keys name and sequence.  Each sequence name is also split into
     id and description on the first whitespace, if any.
     __FORMAT_TEXT__
  
  Arguments:
  $args_string
  
  Examples:
     Parse a FASTA file into records, stripping newlines in the sequence
        recs-fromfasta --oneline < example.fasta
  USAGE
APP_RECORDSTREAM_OPERATION_FROMFASTA

$fatpacked{"App/RecordStream/Operation/fromsam.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'APP_RECORDSTREAM_OPERATION_FROMSAM';
  use strict;use warnings;package App::RecordStream::Operation::fromsam;use base qw(App::RecordStream::Operation);sub init {my$this=shift;my$args=shift;my$options={'flags'=>\($this->{'DECODE_FLAGS'}),'quals|Q'=>\($this->{'DECODE_QUALS'}),};$this->parse_options($args,$options)}sub accept_line {my$this=shift;my$line=shift;return 1 if$line =~ /^@/;my@fields=qw[qname flag rname pos mapq cigar rnext pnext tlen seq qual];my@values=split /\t/,$line;my%record=map {$_=>shift@values}@fields;for my$tag (map {[split /:/,$_,3]}@values){$record{tag}{$tag->[0]}={type=>$tag->[1],value=>$tag->[2],}}$record{quals}=[map {ord($_)- 33}split '',$record{qual}eq '*' ? '' : $record{qual}]if$this->{'DECODE_QUALS'};if ($this->{'DECODE_FLAGS'}){$record{flag}||= 0;$record{flags}={paired=>!!($record{flag}& 0x1),proper_pair=>!!($record{flag}& 0x2),unmapped=>!!($record{flag}& 0x4),mate_unmapped=>!!($record{flag}& 0x8),rc=>!!($record{flag}& 0x10),mate_rc=>!!($record{flag}& 0x20),r1=>!!($record{flag}& 0x40),r2=>!!($record{flag}& 0x80),secondary=>!!($record{flag}& 0x100),qc_failed=>!!($record{flag}& 0x200),duplicate=>!!($record{flag}& 0x400),supplementary=>!!($record{flag}& 0x800),}}$this->push_record(App::RecordStream::Record->new(\%record));return 1}sub usage {my$this=shift;my$options=[['flags','Decode flag bitstring into a "flags" hashref'],['quals','Decode qual string into a "quals" array of numeric values'],];my$args_string=$this->options_string($options);return <<USAGE}1;
  Usage: recs fromsam <args> [<files>]
     __FORMAT_TEXT__
     Each line of input (or lines of <files>) is parsed as a SAM (Sequence
     Alignment/Map) formatted record to produce a recs output record.  To parse a
     BAM file, please pipe it from \`samtools view file.bam\` into this command.
  
     The output records will contain the following fields:
     __FORMAT_TEXT__
  
        qname flag rname pos mapq cigar rnext pnext tlen seq qual
  
     __FORMAT_TEXT__
     Additional optional SAM fields are parsed into the "tag" key, which is a
     hash keyed by the SAM field tag name.  The values are also hashes containing
     a "type" and "value" field.  For example, a read group tag will end up in your
     record like this:
     __FORMAT_TEXT__
  
        tags => {
          RG => {
            type  => "Z",
            value => "...",
          }
        }
  
     __FORMAT_TEXT__
     Refer to the SAM spec for field details: http://samtools.github.io/hts-specs/SAMv1.pdf
     __FORMAT_TEXT__
  
  Arguments:
  $args_string
  
  Examples:
     Parse SAM and calculate average mapping quality:
        recs fromsam input.sam | recs collate -a avg,mapq
     Parse BAM:
        samtools view input.bam | recs fromsam
     Parse SAM pre-filtered by read group:
        samtools view -r SAMPLE-1234 input.sam | recs fromsam
     The same, but probably slower:
        recs fromsam input.sam | recs grep '{{tag/RG/value}} eq "SAMPLE-1234"'
  USAGE
APP_RECORDSTREAM_OPERATION_FROMSAM

$fatpacked{"App/RecordStream/Operation/tofasta.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'APP_RECORDSTREAM_OPERATION_TOFASTA';
  package App::RecordStream::Operation::tofasta;use strict;use warnings;use base qw(App::RecordStream::Operation);sub init {my$self=shift;my$args=shift;my ($id,$desc,$seq)=qw(id description sequence);my$spec={"id|i=s"=>\$id,"description|d=s"=>\$desc,"sequence|s=s"=>\$seq,"width|w=i"=>\($self->{WIDTH}),"oneline"=>\($self->{ONELINE}),"passthru"=>\($self->{PASSTHRU}),};$self->parse_options($args,$spec);die "--passthru is incompatible with --oneline and --width\n\n" if$self->{PASSTHRU}and ($self->{ONELINE}or $self->{WIDTH});$self->{WIDTH}||= 60;$self->{KEYS}{id}=$id;$self->{KEYS}{desc}=$desc;$self->{KEYS}{seq}=$seq}sub accept_record {my$self=shift;my$record=shift;my%props=map {;"-$_"=>${$record->guess_key_from_spec($self->{KEYS}{$_})}}grep {$self->{KEYS}{$_}ne 'NONE'}keys %{$self->{KEYS}};if (not $self->{PASSTHRU}and defined$props{'-seq'}){$props{'-seq'}=~ s/\s+//g;if ($self->{ONELINE}){$props{'-seq'}=~ s/[\n\r]//g}elsif ($self->{WIDTH}){my$width=$self->{WIDTH}+ 0;$props{'-seq'}=~ s/(.{$width})/$1\n/g}}$props{'-id'}="" unless defined$props{'-id'}or $self->{PASSTHRU};my$fasta=sprintf ">%s\n%s",join(" ",map {s/[\n\r]//g;$_}grep {defined}@props{'-id','-desc'}),$props{'-seq'}|| "";chomp$fasta;$self->push_line($fasta);return 1}sub add_help_types {my$self=shift;$self->use_help_type('keyspecs');$self->use_help_type('keys')}sub usage {my$self=shift;my$options=[['id|-i <keyspec>','Record field to use for the sequence id' ],['description|-d <keyspec>','Record field to use for the sequence description' ],['sequence|-s <keyspec>','Record field to use for the sequence itself' ],['width|w <#>','Format sequence blocks to # characters wide' ],['oneline','Format sequences on a single long line' ],['passthru','Pass through nucleotides unformatted' ],];my$args_string=$self->options_string($options);return <<USAGE}1;
  Usage: recs-tofasta <options> [files]
     __FORMAT_TEXT__
     Outputs a FASTA-formatted sequence for each record.
  
     By default the keys "id", "description", and "sequence" are used to build
     the FASTA format.  These defaults match up with what recs-fromfasta produces.
     The special key name "NONE" may be used to indicate that no key should be
     used, disabling the defaults.  Note that specifying NONE for --id will cause
     any --description to appear with a space between it and the line's ">",
     unless --passthru is also used.
     __FORMAT_TEXT__
  
  Arguments:
  $args_string
  
  Examples:
    # Remove gaps from a fasta file
    recs-fromfasta seqs.fa | recs-xform '{{sequence}} =~ s/-//g' | recs-tofasta > seqs-nogaps.fa
  USAGE
APP_RECORDSTREAM_OPERATION_TOFASTA

s/^  //mg for values %fatpacked;

my $class = 'FatPacked::'.(0+\%fatpacked);
no strict 'refs';
*{"${class}::files"} = sub { keys %{$_[0]} };

if ($] < 5.008) {
  *{"${class}::INC"} = sub {
    if (my $fat = $_[0]{$_[1]}) {
      my $pos = 0;
      my $last = length $fat;
      return (sub {
        return 0 if $pos == $last;
        my $next = (1 + index $fat, "\n", $pos) || $last;
        $_ .= substr $fat, $pos, $next - $pos;
        $pos = $next;
        return 1;
      });
    }
  };
}

else {
  *{"${class}::INC"} = sub {
    if (my $fat = $_[0]{$_[1]}) {
      open my $fh, '<', \$fat
        or die "FatPacker error loading $_[1] (could be a perl installation issue?)";
      return $fh;
    }
    return;
  };
}

unshift @INC, bless \%fatpacked, $class;
  } # END OF FATPACK CODE

use App::RecordStream::Bio; 1;
